/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce;

import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.io.FilenameUtils;
import org.apache.gobblin.compaction.mapreduce.RecordKeyDedupReducerBase;
import org.apache.gobblin.compaction.mapreduce.RecordKeyMapperBase;
import org.apache.gobblin.util.recordcount.CompactionRecordCountProvider;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactorOutputCommitter
extends FileOutputCommitter {
    public static final String COMPACTION_OUTPUT_EXTENSION = "compaction.output.extension";
    public static final String DEFAULT_COMPACTION_OUTPUT_EXTENSION = "avro";
    private static final Logger LOG = LoggerFactory.getLogger(CompactorOutputCommitter.class);
    private final String compactionFileExtension;

    public CompactorOutputCommitter(Path output, TaskAttemptContext context) throws IOException {
        super(output, context);
        this.compactionFileExtension = context.getConfiguration().get(COMPACTION_OUTPUT_EXTENSION, DEFAULT_COMPACTION_OUTPUT_EXTENSION);
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        Path workPath = this.getWorkPath();
        FileSystem fs = workPath.getFileSystem(context.getConfiguration());
        if (fs.exists(workPath)) {
            String fileNamePrefix;
            long recordCount = CompactorOutputCommitter.getRecordCountFromCounter(context, RecordKeyDedupReducerBase.EVENT_COUNTER.RECORD_COUNT);
            if (recordCount == 0L) {
                fileNamePrefix = "part-m-";
                recordCount = CompactorOutputCommitter.getRecordCountFromCounter(context, RecordKeyMapperBase.EVENT_COUNTER.RECORD_COUNT);
            } else {
                fileNamePrefix = "part-r-";
            }
            String fileName = CompactionRecordCountProvider.constructFileName((String)fileNamePrefix, (String)("." + this.compactionFileExtension), (long)recordCount);
            for (FileStatus status : fs.listStatus(workPath, new PathFilter(){

                public boolean accept(Path path) {
                    return FilenameUtils.isExtension((String)path.getName(), (String)CompactorOutputCommitter.this.compactionFileExtension);
                }
            })) {
                Path newPath = new Path(status.getPath().getParent(), fileName);
                LOG.info(String.format("Renaming %s to %s", status.getPath(), newPath));
                fs.rename(status.getPath(), newPath);
                context.getCounter((Enum)EVENT_COUNTER.OUTPUT_FILE_COUNT).increment(1L);
            }
        }
        super.commitTask(context);
    }

    private static long getRecordCountFromCounter(TaskAttemptContext context, Enum<?> counterName) {
        try {
            Method getCounterMethod = context.getClass().getMethod("getCounter", Enum.class);
            return ((Counter)getCounterMethod.invoke((Object)context, counterName)).getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading record count counter", e);
        }
    }

    public static enum EVENT_COUNTER {
        OUTPUT_FILE_COUNT;

    }
}

