/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.dataset;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.gobblin.compaction.dataset.Dataset;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.source.extractor.extract.kafka.ConfigStoreUtils;
import org.apache.gobblin.util.DatasetFilterUtils;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public abstract class DatasetsFinder
implements org.apache.gobblin.dataset.DatasetsFinder<Dataset> {
    public static final double HIGH_PRIORITY = 3.0;
    public static final double NORMAL_PRIORITY = 2.0;
    public static final double LOW_PRIORITY = 1.0;
    public static final String TMP_OUTPUT_SUBDIR = "output";
    protected final State state;
    protected final Configuration conf;
    protected final FileSystem fs;
    protected final String inputDir;
    protected final String destDir;
    protected final String tmpOutputDir;
    protected final List<Pattern> blacklist;
    protected final List<Pattern> whitelist;
    protected final List<Pattern> highPriority;
    protected final List<Pattern> normalPriority;
    protected final boolean recompactDatasets;

    public DatasetsFinder(State state) {
        this(state, DatasetsFinder.getFileSystem(state));
    }

    @VisibleForTesting
    DatasetsFinder(State state, FileSystem fs) {
        this.state = state;
        this.conf = HadoopUtils.getConfFromState((State)state);
        this.fs = fs;
        this.inputDir = this.getInputDir();
        this.destDir = this.getDestDir();
        this.tmpOutputDir = this.getTmpOutputDir();
        this.blacklist = DatasetFilterUtils.getPatternList((State)state, (String)"compaction.blacklist");
        this.whitelist = DatasetFilterUtils.getPatternList((State)state, (String)"compaction.whitelist");
        this.setTopicsFromConfigStore(state);
        this.highPriority = this.getHighPriorityPatterns();
        this.normalPriority = this.getNormalPriorityPatterns();
        this.recompactDatasets = this.getRecompactDatasets();
    }

    private void setTopicsFromConfigStore(State state) {
        HashSet blacklistTopicsFromConfigStore = new HashSet();
        HashSet whitelistTopicsFromConfigStore = new HashSet();
        ConfigStoreUtils.setTopicsFromConfigStore((Properties)state.getProperties(), blacklistTopicsFromConfigStore, whitelistTopicsFromConfigStore, (String)"compaction.blacklist", (String)"compaction.whitelist");
        this.blacklist.addAll(DatasetFilterUtils.getPatternsFromStrings(new ArrayList(blacklistTopicsFromConfigStore)));
        this.whitelist.addAll(DatasetFilterUtils.getPatternsFromStrings(new ArrayList(whitelistTopicsFromConfigStore)));
    }

    public abstract Set<Dataset> findDistinctDatasets() throws IOException;

    public List<Dataset> findDatasets() throws IOException {
        return Lists.newArrayList(this.findDistinctDatasets());
    }

    public Path commonDatasetRoot() {
        return new Path(this.destDir);
    }

    private String getInputDir() {
        Preconditions.checkArgument((boolean)this.state.contains("compaction.input.dir"), (Object)"Missing required property compaction.input.dir");
        return this.state.getProp("compaction.input.dir");
    }

    private String getDestDir() {
        Preconditions.checkArgument((boolean)this.state.contains("compaction.dest.dir"), (Object)"Missing required property compaction.dest.dir");
        return this.state.getProp("compaction.dest.dir");
    }

    private String getTmpOutputDir() {
        return new Path(this.state.getProp("compaction.tmp.dest.dir", "/tmp/gobblin-compaction"), TMP_OUTPUT_SUBDIR).toString();
    }

    private static FileSystem getFileSystem(State state) {
        try {
            if (state.contains("compaction.file.system.uri")) {
                URI uri = URI.create(state.getProp("compaction.file.system.uri"));
                return FileSystem.get((URI)uri, (Configuration)HadoopUtils.getConfFromState((State)state));
            }
            return FileSystem.get((Configuration)HadoopUtils.getConfFromState((State)state));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get filesystem for datasetsFinder.", e);
        }
    }

    private List<Pattern> getHighPriorityPatterns() {
        List list = this.state.getPropAsList("compaction.high.priority.topics", "");
        return DatasetFilterUtils.getPatternsFromStrings((List)list);
    }

    private List<Pattern> getNormalPriorityPatterns() {
        List list = this.state.getPropAsList("compaction.normal.priority.topics", "");
        return DatasetFilterUtils.getPatternsFromStrings((List)list);
    }

    private boolean getRecompactDatasets() {
        return this.state.getPropAsBoolean("compaction.recompact.from.dest.paths", false);
    }

    protected double getDatasetPriority(String datasetName) {
        double priority = 1.0;
        if (DatasetFilterUtils.stringInPatterns((String)datasetName, this.highPriority)) {
            priority = 3.0;
        } else if (DatasetFilterUtils.stringInPatterns((String)datasetName, this.normalPriority)) {
            priority = 2.0;
        }
        return priority;
    }
}

