/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.action;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.mapreduce.CompactionJobConfigurator;
import org.apache.gobblin.compaction.parser.CompactionPathParser;
import org.apache.gobblin.compaction.verify.InputRecordCountHelper;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.iceberg.GobblinMCEProducer;
import org.apache.gobblin.iceberg.Utils.IcebergUtils;
import org.apache.gobblin.iceberg.publisher.GobblinMCEPublisher;
import org.apache.gobblin.metadata.OperationType;
import org.apache.gobblin.metadata.SchemaSource;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.gobblin.util.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.types.Type;
import org.apache.orc.OrcConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionGMCEPublishingAction
implements CompactionCompleteAction<FileSystemDataset> {
    private static final Logger log = LoggerFactory.getLogger(CompactionGMCEPublishingAction.class);
    public static final String ICEBERG_ID_ATTRIBUTE = "iceberg.id";
    public static final String ICEBERG_REQUIRED_ATTRIBUTE = "iceberg.required";
    public static final String GMCE_EMITTED_KEY = "GMCE.emitted";
    private final State state;
    private final CompactionJobConfigurator configurator;
    private final Configuration conf;
    private InputRecordCountHelper helper;
    private EventSubmitter eventSubmitter;

    public CompactionGMCEPublishingAction(State state, CompactionJobConfigurator configurator, InputRecordCountHelper helper) {
        if (!(state instanceof WorkUnitState)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " only supports workunit state");
        }
        this.state = state;
        this.configurator = configurator;
        this.conf = HadoopUtils.getConfFromState((State)state);
        this.helper = helper;
    }

    public CompactionGMCEPublishingAction(State state, CompactionJobConfigurator configurator) {
        this(state, configurator, new InputRecordCountHelper(state));
    }

    @Override
    public void onCompactionJobComplete(FileSystemDataset dataset) throws IOException {
        if (dataset.isVirtual()) {
            return;
        }
        CompactionPathParser.CompactionParserResult result = new CompactionPathParser(this.state).parse(dataset);
        String datasetDir = Joiner.on((String)"/").join((Object)result.getDstBaseDir(), (Object)result.getDatasetName(), new Object[0]);
        this.state.setProp("data.publisher.dataset.dir", (Object)datasetDir);
        try (GobblinMCEProducer producer = GobblinMCEProducer.getGobblinMCEProducer((State)this.state);){
            producer.sendGMCE(this.getNewFileMetrics(result), null, (List)Lists.newArrayList(this.configurator.getOldFiles()), null, OperationType.rewrite_files, SchemaSource.NONE);
        }
        State compactionState = this.helper.loadState(new Path(result.getDstAbsoluteDir()));
        compactionState.setProp(GMCE_EMITTED_KEY, (Object)true);
        this.helper.saveState(new Path(result.getDstAbsoluteDir()), compactionState);
        this.configurator.getOldFiles().clear();
    }

    private Map<Path, Metrics> getNewFileMetrics(CompactionPathParser.CompactionParserResult result) {
        NameMapping mapping = null;
        try {
            if (IcebergUtils.getIcebergFormat((State)this.state) == FileFormat.ORC) {
                String s = this.configurator.getConfiguredJob().getConfiguration().get(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute());
                TypeDescription orcSchema = TypeDescription.fromString((String)s);
                for (int i = 0; i <= orcSchema.getMaximumId(); ++i) {
                    orcSchema.findSubtype(i).setAttribute(ICEBERG_ID_ATTRIBUTE, Integer.toString(i));
                    orcSchema.findSubtype(i).setAttribute(ICEBERG_REQUIRED_ATTRIBUTE, Boolean.toString(true));
                }
                Schema icebergSchema = ORCSchemaUtil.convert((TypeDescription)orcSchema);
                this.state.setProp("avro.schema.with.iceberg.id", (Object)AvroSchemaUtil.convert((Type)icebergSchema.asStruct()).toString());
                mapping = MappingUtil.create((Schema)icebergSchema);
            }
        }
        catch (Exception e) {
            log.warn("Table {} contains complex union type which is not compatible with iceberg, will not calculate the metrics for it", (Object)result.getDatasetName());
        }
        HashMap<Path, Metrics> newFiles = new HashMap<Path, Metrics>();
        for (Path filePath : this.configurator.getDstNewFiles()) {
            newFiles.put(filePath, GobblinMCEPublisher.getMetrics((State)this.state, (Path)filePath, (Configuration)this.conf, mapping));
        }
        return newFiles;
    }

    @Override
    public void addEventSubmitter(EventSubmitter submitter) {
        this.eventSubmitter = submitter;
    }
}

