/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.orc;

import java.io.IOException;
import org.apache.gobblin.compaction.mapreduce.orc.OrcUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapreduce.OrcMapreduceRecordReader;

public class OrcValueCombineFileRecordReader
extends OrcMapreduceRecordReader {
    private final CombineFileSplit split;
    private final Integer splitIdx;

    public OrcValueCombineFileRecordReader(CombineFileSplit split, TaskAttemptContext context, Integer idx) throws IOException {
        this(OrcValueCombineFileRecordReader.getRecordReaderFromFile(split, context, idx), OrcValueCombineFileRecordReader.getSchema(split, context, idx), split, idx);
    }

    public OrcValueCombineFileRecordReader(RecordReader reader, TypeDescription schema, CombineFileSplit split, Integer splitIdx) throws IOException {
        super(reader, schema);
        this.split = split;
        this.splitIdx = splitIdx;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        super.initialize((InputSplit)new FileSplit(this.split.getPath(this.splitIdx.intValue()), this.split.getOffset(this.splitIdx.intValue()), this.split.getLength(this.splitIdx.intValue()), null), taskAttemptContext);
    }

    private static TypeDescription getSchema(CombineFileSplit split, TaskAttemptContext context, Integer idx) throws IOException {
        Path path = split.getPath(idx.intValue());
        return OrcUtils.getTypeDescriptionFromFile(context.getConfiguration(), path);
    }

    private static RecordReader getRecordReaderFromFile(CombineFileSplit split, TaskAttemptContext context, Integer idx) throws IOException {
        Path path = split.getPath(idx.intValue());
        return OrcUtils.getRecordReaderFromFile(context.getConfiguration(), path).rows();
    }
}

