/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.mapreduce.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.gobblin.compaction.mapreduce.avro.MRCompactorAvroKeyDedupJobRunner;
import org.apache.gobblin.util.FileListUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.ConvertTreeReaderFactory;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.orc.mapred.OrcList;
import org.apache.orc.mapred.OrcMap;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcTimestamp;
import org.apache.orc.mapred.OrcUnion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcUtils {
    private static final Logger log = LoggerFactory.getLogger(OrcUtils.class);

    private OrcUtils() {
    }

    public static TypeDescription getTypeDescriptionFromFile(Configuration conf, Path orcFilePath) throws IOException {
        return OrcUtils.getRecordReaderFromFile(conf, orcFilePath).getSchema();
    }

    public static Reader getRecordReaderFromFile(Configuration conf, Path orcFilePath) throws IOException {
        return OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)new OrcFile.ReaderOptions(conf));
    }

    public static TypeDescription getNewestSchemaFromSource(Job job, FileSystem fs) throws IOException {
        Object[] sourceDirs = FileInputFormat.getInputPaths((JobContext)job);
        if (sourceDirs.length == 0) {
            throw new IllegalStateException("There should be at least one directory specified for the MR job");
        }
        ArrayList files = new ArrayList();
        for (Path path : sourceDirs) {
            files.addAll(FileListUtils.listFilesRecursively((FileSystem)fs, (Path)path));
        }
        Collections.sort(files, new MRCompactorAvroKeyDedupJobRunner.LastModifiedDescComparator());
        for (FileStatus status : files) {
            TypeDescription resultSchema = OrcUtils.getTypeDescriptionFromFile(job.getConfiguration(), status.getPath());
            if (resultSchema == null) continue;
            return resultSchema;
        }
        throw new IllegalStateException(String.format("There's no file carrying orc file schema in the list of directories: %s", Arrays.toString(sourceDirs)));
    }

    static boolean isEvolutionValid(TypeDescription fileType, TypeDescription readerType) {
        boolean isOk = true;
        if (fileType.getCategory() == readerType.getCategory()) {
            switch (readerType.getCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case DOUBLE: 
                case FLOAT: 
                case STRING: 
                case TIMESTAMP: 
                case BINARY: 
                case DATE: {
                    break;
                }
                case CHAR: 
                case VARCHAR: {
                    break;
                }
                case DECIMAL: {
                    break;
                }
                case UNION: 
                case MAP: 
                case LIST: {
                    List fileChildren = fileType.getChildren();
                    List readerChildren = readerType.getChildren();
                    if (fileChildren.size() == readerChildren.size()) {
                        for (int i = 0; i < fileChildren.size(); ++i) {
                            isOk &= OrcUtils.isEvolutionValid((TypeDescription)fileChildren.get(i), (TypeDescription)readerChildren.get(i));
                        }
                        return isOk;
                    }
                    return false;
                }
                case STRUCT: {
                    int i;
                    List readerChildren = readerType.getChildren();
                    List fileChildren = fileType.getChildren();
                    List readerFieldNames = readerType.getFieldNames();
                    List fileFieldNames = fileType.getFieldNames();
                    HashMap fileTypesIdx = new HashMap();
                    for (i = 0; i < fileFieldNames.size(); ++i) {
                        String fileFieldName = (String)fileFieldNames.get(i);
                        fileTypesIdx.put(fileFieldName, fileChildren.get(i));
                    }
                    for (i = 0; i < readerFieldNames.size(); ++i) {
                        String readerFieldName = (String)readerFieldNames.get(i);
                        TypeDescription readerField = (TypeDescription)readerChildren.get(i);
                        TypeDescription fileField = (TypeDescription)fileTypesIdx.get(readerFieldName);
                        if (fileField == null) continue;
                        isOk &= OrcUtils.isEvolutionValid(fileField, readerField);
                    }
                    return isOk;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + readerType);
                }
            }
            return isOk;
        }
        return ConvertTreeReaderFactory.canConvert((TypeDescription)fileType, (TypeDescription)readerType);
    }

    private static WritableComparable structConversionHelper(WritableComparable w, WritableComparable v, TypeDescription targetSchema) {
        if (w instanceof OrcStruct) {
            OrcUtils.upConvertOrcStruct((OrcStruct)w, (OrcStruct)v, targetSchema);
        } else if (w instanceof OrcList) {
            OrcList castedList = (OrcList)w;
            OrcList targetList = (OrcList)v;
            TypeDescription elementType = (TypeDescription)targetSchema.getChildren().get(0);
            targetList.clear();
            for (int i = 0; i < castedList.size(); ++i) {
                WritableComparable targetListRecordContainer = OrcUtils.createValueRecursively(elementType, 0);
                targetList.add(i, (Object)OrcUtils.structConversionHelper((WritableComparable)castedList.get(i), targetListRecordContainer, elementType));
            }
        } else if (w instanceof OrcMap) {
            OrcMap castedMap = (OrcMap)w;
            OrcMap targetMap = (OrcMap)v;
            TypeDescription valueSchema = (TypeDescription)targetSchema.getChildren().get(1);
            targetMap.clear();
            for (Object entry : castedMap.entrySet()) {
                Map.Entry castedEntry = (Map.Entry)entry;
                WritableComparable targetMapRecordContainer = OrcUtils.createValueRecursively(valueSchema);
                targetMapRecordContainer = OrcUtils.structConversionHelper((WritableComparable)castedEntry.getValue(), targetMapRecordContainer, valueSchema);
                targetMap.put(castedEntry.getKey(), (Object)targetMapRecordContainer);
            }
        } else if (w instanceof OrcUnion) {
            OrcUnion castedUnion = (OrcUnion)w;
            OrcUnion targetUnion = (OrcUnion)v;
            byte tag = castedUnion.getTag();
            TypeDescription targetMemberSchema = (TypeDescription)targetSchema.getChildren().get(tag);
            targetUnion.set((int)tag, OrcUtils.structConversionHelper((WritableComparable)castedUnion.getObject(), OrcUtils.createValueRecursively(targetMemberSchema), targetMemberSchema));
        } else {
            OrcUtils.handlePrimitiveWritableComparable(w, v);
        }
        return v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public static void upConvertOrcStruct(OrcStruct oldStruct, OrcStruct newStruct, TypeDescription targetSchema) {
        Preconditions.checkArgument((boolean)newStruct.getSchema().equals((Object)targetSchema));
        int indexInNewSchema = 0;
        List oldSchemaFieldNames = oldStruct.getSchema().getFieldNames();
        Map oldSchemaIndex = IntStream.range(0, oldSchemaFieldNames.size()).boxed().collect(Collectors.toMap(oldSchemaFieldNames::get, Function.identity()));
        List oldSchemaTypes = oldStruct.getSchema().getChildren();
        List newSchemaTypes = targetSchema.getChildren();
        for (String fieldName : targetSchema.getFieldNames()) {
            if (oldSchemaFieldNames.contains(fieldName) && oldStruct.getFieldValue(fieldName) != null) {
                TypeDescription newFieldSchema;
                int fieldIndex = (Integer)oldSchemaIndex.get(fieldName);
                TypeDescription oldFieldSchema = (TypeDescription)oldSchemaTypes.get(fieldIndex);
                if (!OrcUtils.isEvolutionValid(oldFieldSchema, newFieldSchema = (TypeDescription)newSchemaTypes.get(indexInNewSchema))) throw new SchemaEvolution.IllegalEvolutionException(String.format("ORC does not support type conversion from file type %s to reader type %s ", oldFieldSchema.toString(), newFieldSchema.toString()));
                WritableComparable oldField = oldStruct.getFieldValue(fieldName);
                WritableComparable newField = newStruct.getFieldValue(fieldName);
                newField = newField == null ? OrcUtils.createValueRecursively(newFieldSchema) : newField;
                newStruct.setFieldValue(fieldName, OrcUtils.structConversionHelper(oldField, newField, newFieldSchema));
            } else {
                newStruct.setFieldValue(fieldName, null);
            }
            ++indexInNewSchema;
        }
    }

    public static void handlePrimitiveWritableComparable(WritableComparable from, WritableComparable to) {
        if (from instanceof ByteWritable) {
            if (to instanceof ByteWritable) {
                ((ByteWritable)to).set(((ByteWritable)from).get());
                return;
            }
            if (to instanceof ShortWritable) {
                ((ShortWritable)to).set((short)((ByteWritable)from).get());
                return;
            }
            if (to instanceof IntWritable) {
                ((IntWritable)to).set((int)((ByteWritable)from).get());
                return;
            }
            if (to instanceof LongWritable) {
                ((LongWritable)to).set((long)((ByteWritable)from).get());
                return;
            }
            if (to instanceof DoubleWritable) {
                ((DoubleWritable)to).set((double)((ByteWritable)from).get());
                return;
            }
        } else if (from instanceof ShortWritable) {
            if (to instanceof ShortWritable) {
                ((ShortWritable)to).set(((ShortWritable)from).get());
                return;
            }
            if (to instanceof IntWritable) {
                ((IntWritable)to).set((int)((ShortWritable)from).get());
                return;
            }
            if (to instanceof LongWritable) {
                ((LongWritable)to).set((long)((ShortWritable)from).get());
                return;
            }
            if (to instanceof DoubleWritable) {
                ((DoubleWritable)to).set((double)((ShortWritable)from).get());
                return;
            }
        } else if (from instanceof IntWritable) {
            if (to instanceof IntWritable) {
                ((IntWritable)to).set(((IntWritable)from).get());
                return;
            }
            if (to instanceof LongWritable) {
                ((LongWritable)to).set((long)((IntWritable)from).get());
                return;
            }
            if (to instanceof DoubleWritable) {
                ((DoubleWritable)to).set((double)((IntWritable)from).get());
                return;
            }
        } else if (from instanceof LongWritable) {
            if (to instanceof LongWritable) {
                ((LongWritable)to).set(((LongWritable)from).get());
                return;
            }
            if (to instanceof DoubleWritable) {
                ((DoubleWritable)to).set((double)((LongWritable)from).get());
                return;
            }
        } else if (from instanceof DoubleWritable) {
            if (to instanceof DoubleWritable) {
                ((DoubleWritable)to).set(((DoubleWritable)from).get());
                return;
            }
        } else if (from instanceof BytesWritable) {
            if (to instanceof BytesWritable) {
                ((BytesWritable)to).set((BytesWritable)from);
                return;
            }
        } else if (from instanceof FloatWritable) {
            if (to instanceof FloatWritable) {
                ((FloatWritable)to).set(((FloatWritable)from).get());
                return;
            }
        } else if (from instanceof Text) {
            if (to instanceof Text) {
                ((Text)to).set((Text)from);
                return;
            }
        } else if (from instanceof DateWritable) {
            if (to instanceof DateWritable) {
                ((DateWritable)to).set(((DateWritable)from).get());
                return;
            }
        } else {
            if (from instanceof OrcTimestamp && to instanceof OrcTimestamp) {
                ((OrcTimestamp)to).set(((OrcTimestamp)from).toString());
                return;
            }
            if (from instanceof HiveDecimalWritable && to instanceof HiveDecimalWritable) {
                ((HiveDecimalWritable)to).set(((HiveDecimalWritable)from).getHiveDecimal());
                return;
            }
            if (from instanceof BooleanWritable && to instanceof BooleanWritable) {
                ((BooleanWritable)to).set(((BooleanWritable)from).get());
                return;
            }
        }
        throw new UnsupportedOperationException(String.format("The conversion of primitive-type WritableComparable object from %s to %s is not supported", from.getClass(), to.getClass()));
    }

    public static WritableComparable createValueRecursively(TypeDescription schema, int elemNum) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return new BooleanWritable();
            }
            case BYTE: {
                return new ByteWritable();
            }
            case SHORT: {
                return new ShortWritable();
            }
            case INT: {
                return new IntWritable();
            }
            case LONG: {
                return new LongWritable();
            }
            case FLOAT: {
                return new FloatWritable();
            }
            case DOUBLE: {
                return new DoubleWritable();
            }
            case BINARY: {
                return new BytesWritable();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new Text();
            }
            case DATE: {
                return new DateWritable();
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new OrcTimestamp();
            }
            case DECIMAL: {
                return new HiveDecimalWritable();
            }
            case STRUCT: {
                OrcStruct result = new OrcStruct(schema);
                int c = 0;
                for (TypeDescription child : schema.getChildren()) {
                    result.setFieldValue(c++, OrcUtils.createValueRecursively(child, elemNum));
                }
                return result;
            }
            case UNION: {
                return new OrcUnion(schema);
            }
            case LIST: {
                OrcList result = new OrcList(schema);
                for (int i = 0; i < elemNum; ++i) {
                    result.add((Object)OrcUtils.createValueRecursively((TypeDescription)schema.getChildren().get(0), elemNum));
                }
                return result;
            }
            case MAP: {
                OrcMap result = new OrcMap(schema);
                for (int i = 0; i < elemNum; ++i) {
                    result.put((Object)OrcUtils.createValueRecursively((TypeDescription)schema.getChildren().get(0), elemNum), (Object)OrcUtils.createValueRecursively((TypeDescription)schema.getChildren().get(1), elemNum));
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Unknown type " + schema);
    }

    public static WritableComparable createValueRecursively(TypeDescription schema) {
        return OrcUtils.createValueRecursively(schema, 1);
    }

    public static boolean eligibleForUpConvertHelper(TypeDescription originalSchema, TypeDescription targetSchema) {
        if (!targetSchema.getCategory().isPrimitive()) {
            if (originalSchema.getCategory() != targetSchema.getCategory()) {
                return false;
            }
            if (targetSchema.getCategory().equals((Object)TypeDescription.Category.LIST)) {
                Preconditions.checkArgument((originalSchema.getChildren() != null ? 1 : 0) != 0, (Object)("Illegal format of ORC schema as:" + originalSchema));
                return OrcUtils.eligibleForUpConvertHelper((TypeDescription)originalSchema.getChildren().get(0), (TypeDescription)targetSchema.getChildren().get(0));
            }
            if (targetSchema.getCategory().equals((Object)TypeDescription.Category.MAP)) {
                Preconditions.checkArgument((originalSchema.getChildren() != null ? 1 : 0) != 0, (Object)("Illegal format of ORC schema as:" + originalSchema));
                return OrcUtils.eligibleForUpConvertHelper((TypeDescription)originalSchema.getChildren().get(0), (TypeDescription)targetSchema.getChildren().get(0)) && OrcUtils.eligibleForUpConvertHelper((TypeDescription)originalSchema.getChildren().get(1), (TypeDescription)targetSchema.getChildren().get(1));
            }
            if (targetSchema.getCategory().equals((Object)TypeDescription.Category.UNION)) {
                return true;
            }
            if (targetSchema.getCategory().equals((Object)TypeDescription.Category.STRUCT)) {
                if (!originalSchema.getFieldNames().containsAll(targetSchema.getFieldNames())) {
                    return false;
                }
                boolean result = true;
                for (int i = 0; i < targetSchema.getFieldNames().size(); ++i) {
                    String subSchemaFieldName = (String)targetSchema.getFieldNames().get(i);
                    result &= OrcUtils.eligibleForUpConvertHelper(originalSchema.findSubtype(subSchemaFieldName), (TypeDescription)targetSchema.getChildren().get(i));
                }
                return result;
            }
            return true;
        }
        return originalSchema.getCategory().equals((Object)targetSchema.getCategory());
    }

    public static boolean eligibleForUpConvert(TypeDescription originalSchema, TypeDescription targetSchema) {
        return OrcUtils.eligibleForUpConvertHelper(originalSchema, targetSchema) || OrcUtils.eligibleForUpConvertHelper(targetSchema, originalSchema);
    }
}

