/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.action;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.mapreduce.CompactionJobConfigurator;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.gobblin.metrics.event.EventSubmitter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionMarkDirectoryAction
implements CompactionCompleteAction<FileSystemDataset> {
    private static final Logger log = LoggerFactory.getLogger(CompactionMarkDirectoryAction.class);
    protected State state;
    private CompactionJobConfigurator configurator;
    private FileSystem fs;
    private EventSubmitter eventSubmitter;

    public CompactionMarkDirectoryAction(State state, CompactionJobConfigurator configurator) {
        if (!(state instanceof WorkUnitState)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " only supports workunit state");
        }
        this.state = state;
        this.configurator = configurator;
        this.fs = configurator.getFs();
    }

    @Override
    public void onCompactionJobComplete(FileSystemDataset dataset) throws IOException {
        if (dataset.isVirtual()) {
            return;
        }
        boolean renamingRequired = this.state.getPropAsBoolean("compaction.rename.source.dir.enabled", false);
        if (renamingRequired) {
            Collection<Path> paths = this.configurator.getMapReduceInputPaths();
            for (Path path : paths) {
                Path newPath = new Path(path.getParent(), path.getName() + "_COMPLETE");
                log.info("[{}] Renaming {} to {}", new Object[]{dataset.datasetURN(), path, newPath});
                this.fs.rename(path, newPath);
            }
            if (this.eventSubmitter != null) {
                ImmutableMap eventMetadataMap = ImmutableMap.of((Object)"datasetUrn", (Object)dataset.datasetURN(), (Object)"renameDirPaths", (Object)Joiner.on((char)',').join(paths));
                this.eventSubmitter.submit("CompactionMarkDirComplete", (Map)eventMetadataMap);
            }
        }
    }

    @Override
    public void addEventSubmitter(EventSubmitter submitter) {
        this.eventSubmitter = submitter;
    }

    @ConstructorProperties(value={"state", "configurator", "fs", "eventSubmitter"})
    public CompactionMarkDirectoryAction(State state, CompactionJobConfigurator configurator, FileSystem fs, EventSubmitter eventSubmitter) {
        this.state = state;
        this.configurator = configurator;
        this.fs = fs;
        this.eventSubmitter = eventSubmitter;
    }
}

