/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.hivebasedconstructs;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.gobblin.compaction.hivebasedconstructs.MRCompactionEntity;
import org.apache.gobblin.compaction.listeners.CompactorListener;
import org.apache.gobblin.compaction.mapreduce.MRCompactor;
import org.apache.gobblin.compaction.mapreduce.avro.ConfBasedDeltaFieldProvider;
import org.apache.gobblin.writer.DataWriter;
import org.apache.hadoop.fs.Path;

public class CompactionLauncherWriter
implements DataWriter<MRCompactionEntity> {
    public void write(MRCompactionEntity compactionEntity) throws IOException {
        Preconditions.checkNotNull((Object)compactionEntity);
        ArrayList list = new ArrayList();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)compactionEntity.getProps());
        props.setProperty(ConfBasedDeltaFieldProvider.DELTA_FIELDS_KEY, Joiner.on((char)',').join(compactionEntity.getDeltaList()));
        props.setProperty("compaction.input.dir", compactionEntity.getDataFilesPath().toString());
        String dbTableName = compactionEntity.getDataFilesPath().getName();
        String timestamp = String.valueOf(System.currentTimeMillis());
        props.setProperty("compaction.tmp.dest.dir", new Path(props.getProperty("compaction.tmp.dest.dir"), dbTableName).toString());
        props.setProperty("compaction.dest.dir", new Path(new Path(props.getProperty("compaction.dest.dir"), dbTableName), timestamp).toString());
        MRCompactor compactor = new MRCompactor(props, list, (Optional<CompactorListener>)Optional.absent());
        compactor.compact();
    }

    public void commit() throws IOException {
    }

    public void cleanup() throws IOException {
    }

    public long recordsWritten() {
        return 0L;
    }

    public long bytesWritten() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
    }
}

