/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.dataset;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.compaction.dataset.DatasetHelper;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dataset
implements Comparable<Dataset>,
FileSystemDataset {
    private static final Logger log = LoggerFactory.getLogger(Dataset.class);
    public static final double DEFAULT_PRIORITY = 1.0;
    public static final double DEFAULT_PRIORITY_REDUCTION_FACTOR = 0.3333333333333333;
    private final Path outputPath;
    private final Path outputLatePath;
    private final Path outputTmpPath;
    private final Set<Path> additionalInputPaths;
    private final Collection<Throwable> throwables;
    private Set<Path> inputPaths;
    private Set<Path> inputLatePaths;
    private State jobProps;
    private double priority;
    private boolean needToRecompact;
    private final String datasetName;
    private AtomicReference<DatasetState> state;
    private Set<Path> renamePaths;
    @Deprecated
    private double lateDataThresholdForRecompact;

    private Dataset(Builder builder) {
        this.inputPaths = builder.inputPaths;
        this.inputLatePaths = builder.inputLatePaths;
        this.outputPath = builder.outputPath;
        this.outputLatePath = builder.outputLatePath;
        this.outputTmpPath = builder.outputTmpPath;
        this.additionalInputPaths = Sets.newHashSet();
        this.throwables = Collections.synchronizedCollection(Lists.newArrayList());
        this.priority = builder.priority;
        this.lateDataThresholdForRecompact = builder.lateDataThresholdForRecompact;
        this.state = new AtomicReference<DatasetState>(DatasetState.UNVERIFIED);
        this.datasetName = builder.datasetName;
        this.jobProps = builder.jobProps;
        this.renamePaths = builder.renamePaths;
    }

    public Set<Path> inputPaths() {
        return ImmutableSet.copyOf(this.inputPaths);
    }

    public Set<Path> inputLatePaths() {
        return ImmutableSet.copyOf(this.inputLatePaths);
    }

    public Path outputPath() {
        return this.outputPath;
    }

    public Path outputLatePath() {
        return this.outputLatePath;
    }

    public Path outputTmpPath() {
        return this.outputTmpPath;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public boolean needToRecompact() {
        return this.needToRecompact;
    }

    public Set<Path> additionalInputPaths() {
        return this.additionalInputPaths;
    }

    public void addAdditionalInputPath(Path path) {
        this.additionalInputPaths.add(path);
    }

    public void addAdditionalInputPaths(Collection<Path> paths) {
        this.additionalInputPaths.addAll(paths);
    }

    public double priority() {
        return this.priority;
    }

    public DatasetState state() {
        return this.state.get();
    }

    public double reducePriority() {
        return this.reducePriority(0.3333333333333333);
    }

    public double reducePriority(double reductionFactor) {
        this.priority *= 1.0 - reductionFactor;
        return this.priority;
    }

    public void checkIfNeedToRecompact(DatasetHelper datasetHelper) {
        if (datasetHelper.getCondition().isRecompactionNeeded(datasetHelper)) {
            this.needToRecompact = true;
        }
    }

    @Deprecated
    public void checkIfNeedToRecompact(long lateDataCount, long nonLateDataCount) {
        double lateDataPercent = (double)lateDataCount * 1.0 / (double)(lateDataCount + nonLateDataCount);
        log.info("Late data percentage is " + lateDataPercent + " and threshold is " + this.lateDataThresholdForRecompact);
        if (lateDataPercent > this.lateDataThresholdForRecompact) {
            this.needToRecompact = true;
        }
    }

    public void setState(DatasetState state) {
        this.state.set(state);
    }

    public void compareAndSetState(DatasetState expect, DatasetState update) {
        this.state.compareAndSet(expect, update);
    }

    public State jobProps() {
        return this.jobProps;
    }

    public void setJobProps(State jobProps) {
        this.jobProps.addAll(jobProps);
    }

    public void setJobProp(String key, Object value) {
        this.jobProps.setProp(key, value);
    }

    public void overwriteInputPath(Path newInputPath) {
        this.inputPaths = Sets.newHashSet((Object[])new Path[]{newInputPath});
    }

    public void overwriteInputPaths(Set<Path> newInputPaths) {
        this.inputPaths = newInputPaths;
    }

    public void overwriteInputLatePath(Path newInputLatePath) {
        this.inputLatePaths = Sets.newHashSet((Object[])new Path[]{newInputLatePath});
    }

    public void resetNeedToRecompact() {
        this.needToRecompact = false;
    }

    private void cleanAdditionalInputPath() {
        this.additionalInputPaths.clear();
    }

    public void modifyDatasetForRecompact(State recompactState) {
        if (!this.jobProps().getPropAsBoolean("compaction.recompact.all.data", true)) {
            this.overwriteInputPath(this.outputLatePath);
            this.cleanAdditionalInputPath();
        } else {
            this.overwriteInputPath(this.outputPath);
            this.overwriteInputLatePath(this.outputLatePath);
            this.addAdditionalInputPath(this.outputLatePath);
        }
        this.setJobProps(recompactState);
        this.resetNeedToRecompact();
    }

    public String getUrn() {
        return this.simplifyOutputPath().toString();
    }

    public String getName() {
        return this.simplifyOutputPath().getName();
    }

    private Path simplifyOutputPath() {
        Path simplifiedPath = new Path(StringUtils.removeEnd((String)this.outputPath.toString(), (String)this.jobProps().getProp("compaction.job.dest.partition", "")));
        simplifiedPath = new Path(StringUtils.removeEnd((String)simplifiedPath.toString(), (String)this.jobProps().getProp("compaction.dest.subdir", "daily")));
        return simplifiedPath;
    }

    public Collection<Throwable> throwables() {
        return this.throwables;
    }

    public void addThrowable(Throwable t) {
        this.throwables.add(t);
    }

    public void skip(Throwable t) {
        this.setState(DatasetState.COMPACTION_COMPLETE);
        this.throwables.add(t);
    }

    @Override
    public int compareTo(Dataset o) {
        return Double.compare(o.priority, this.priority);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputPaths == null ? 0 : this.inputPaths.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)obj;
        return !(this.inputPaths == null ? other.inputPaths != null : !this.inputPaths.equals(other.inputPaths));
    }

    public String toString() {
        return this.inputPaths.toString();
    }

    public Path datasetRoot() {
        return this.outputPath;
    }

    public String datasetURN() {
        return this.datasetRoot().toString();
    }

    public Set<Path> getRenamePaths() {
        return this.renamePaths;
    }

    public void setRenamePaths(Set<Path> renamePaths) {
        this.renamePaths = renamePaths;
    }

    public static class Builder {
        private Set<Path> inputPaths = Sets.newHashSet();
        private Set<Path> inputLatePaths = Sets.newHashSet();
        private Set<Path> renamePaths = Sets.newHashSet();
        private Path outputPath;
        private Path outputLatePath;
        private Path outputTmpPath;
        private String datasetName;
        private double priority = 1.0;
        private State jobProps = new State();
        @Deprecated
        private double lateDataThresholdForRecompact;

        @Deprecated
        public Builder withInputPath(Path inputPath) {
            return this.addInputPath(inputPath);
        }

        @Deprecated
        public Builder withInputLatePath(Path inputLatePath) {
            return this.addInputLatePath(inputLatePath);
        }

        public Builder addInputPath(Path inputPath) {
            this.inputPaths.add(inputPath);
            return this;
        }

        public Builder addInputLatePath(Path inputLatePath) {
            this.inputLatePaths.add(inputLatePath);
            return this;
        }

        public Builder withOutputPath(Path outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public Builder withOutputLatePath(Path outputLatePath) {
            this.outputLatePath = outputLatePath;
            return this;
        }

        public Builder withOutputTmpPath(Path outputTmpPath) {
            this.outputTmpPath = outputTmpPath;
            return this;
        }

        public Builder withDatasetName(String name) {
            this.datasetName = name;
            return this;
        }

        public Builder withPriority(double priority) {
            this.priority = priority;
            return this;
        }

        public Builder withJobProp(String key, Object value) {
            this.jobProps.setProp(key, value);
            return this;
        }

        @Deprecated
        public Builder withLateDataThresholdForRecompact(double lateDataThresholdForRecompact) {
            this.lateDataThresholdForRecompact = lateDataThresholdForRecompact;
            return this;
        }

        public Dataset build() {
            return new Dataset(this);
        }
    }

    public static enum DatasetState {
        UNVERIFIED,
        VERIFIED,
        GIVEN_UP,
        COMPACTION_COMPLETE;

    }
}

