/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction.suite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.gobblin.compaction.action.CompactionCompleteAction;
import org.apache.gobblin.compaction.action.CompactionCompleteFileOperationAction;
import org.apache.gobblin.compaction.action.CompactionHiveRegistrationAction;
import org.apache.gobblin.compaction.action.CompactionMarkDirectoryAction;
import org.apache.gobblin.compaction.mapreduce.CompactionAvroJobConfigurator;
import org.apache.gobblin.compaction.suite.CompactionSuite;
import org.apache.gobblin.compaction.verify.CompactionAuditCountVerifier;
import org.apache.gobblin.compaction.verify.CompactionThresholdVerifier;
import org.apache.gobblin.compaction.verify.CompactionTimeRangeVerifier;
import org.apache.gobblin.compaction.verify.CompactionVerifier;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.dataset.FileSystemDataset;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionAvroSuite
implements CompactionSuite<FileSystemDataset> {
    private static final Logger log = LoggerFactory.getLogger(CompactionAvroSuite.class);
    public static final String SERIALIZE_COMPACTION_FILE_PATH_NAME = "compaction-file-path-name";
    private State state;
    private CompactionAvroJobConfigurator configurator = null;

    public CompactionAvroSuite(State state) {
        this.state = state;
    }

    @Override
    public List<CompactionVerifier<FileSystemDataset>> getDatasetsFinderVerifiers() {
        LinkedList<CompactionVerifier<FileSystemDataset>> list = new LinkedList<CompactionVerifier<FileSystemDataset>>();
        list.add(new CompactionTimeRangeVerifier(this.state));
        list.add(new CompactionThresholdVerifier(this.state));
        list.add(new CompactionAuditCountVerifier(this.state));
        return list;
    }

    @Override
    public List<CompactionVerifier<FileSystemDataset>> getMapReduceVerifiers() {
        ArrayList<CompactionVerifier<FileSystemDataset>> list = new ArrayList<CompactionVerifier<FileSystemDataset>>();
        return list;
    }

    @Override
    public void save(FileSystemDataset dataset, State state) {
        state.setProp(SERIALIZE_COMPACTION_FILE_PATH_NAME, (Object)dataset.datasetURN());
    }

    @Override
    public FileSystemDataset load(final State state) {
        return new FileSystemDataset(){

            public Path datasetRoot() {
                return new Path(state.getProp(CompactionAvroSuite.SERIALIZE_COMPACTION_FILE_PATH_NAME));
            }

            public String datasetURN() {
                return state.getProp(CompactionAvroSuite.SERIALIZE_COMPACTION_FILE_PATH_NAME);
            }
        };
    }

    @Override
    public List<CompactionCompleteAction<FileSystemDataset>> getCompactionCompleteActions() {
        ArrayList<CompactionCompleteAction<FileSystemDataset>> array = new ArrayList<CompactionCompleteAction<FileSystemDataset>>();
        array.add(new CompactionCompleteFileOperationAction(this.state, this.configurator));
        array.add(new CompactionHiveRegistrationAction(this.state));
        array.add(new CompactionMarkDirectoryAction(this.state, this.configurator));
        return array;
    }

    @Override
    public Job createJob(FileSystemDataset dataset) throws IOException {
        this.configurator = new CompactionAvroJobConfigurator(this.state);
        return this.configurator.createJob(dataset);
    }
}

