/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compaction;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.gobblin.util.JobConfigurationUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.GenericOptionsParser;

public class CliOptions {
    private static final Option JOB_CONFIG_OPTION = Option.builder().argName("job configuration file").desc("Gobblin compaction job configuration file").hasArgs().longOpt("jobconfig").build();
    private static final Option HELP_OPTION = Option.builder((String)"h").argName("help").desc("Display usage information").longOpt("help").build();

    public static Properties parseArgs(Class<?> caller, String[] args, Configuration conf) throws IOException {
        try {
            Properties jobConfig;
            String jobConfigLocation;
            CommandLine cmd;
            if (conf != null) {
                args = new GenericOptionsParser(conf, args).getCommandLine().getArgs();
            }
            if ((cmd = new DefaultParser().parse(CliOptions.options(), args)).hasOption(HELP_OPTION.getOpt())) {
                CliOptions.printUsage(caller);
                System.exit(0);
            }
            if (!cmd.hasOption(jobConfigLocation = JOB_CONFIG_OPTION.getLongOpt())) {
                CliOptions.printUsage(caller);
                System.exit(1);
            }
            if (conf == null) {
                jobConfig = JobConfigurationUtils.fileToProperties((String)cmd.getOptionValue(jobConfigLocation));
            } else {
                jobConfig = JobConfigurationUtils.fileToProperties((String)cmd.getOptionValue(jobConfigLocation), (Configuration)conf);
                JobConfigurationUtils.putConfigurationIntoProperties((Configuration)conf, (Properties)jobConfig);
            }
            return jobConfig;
        }
        catch (ParseException | ConfigurationException e) {
            throw new IOException(e);
        }
    }

    public static Properties parseArgs(Class<?> caller, String[] args) throws IOException {
        return CliOptions.parseArgs(caller, args, null);
    }

    public static void printUsage(Class<?> caller) {
        new HelpFormatter().printHelp(caller.getSimpleName(), CliOptions.options());
    }

    private static Options options() {
        Options options = new Options();
        options.addOption(JOB_CONFIG_OPTION);
        options.addOption(HELP_OPTION);
        return options;
    }
}

