/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.util.StringUtils;
import com.typesafe.config.Config;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.password.PasswordManager;
import org.apache.gobblin.util.ConfigUtils;

@Alpha
public class AWSClusterSecurityManager {
    private final Config config;

    public AWSClusterSecurityManager(Config config) {
        this.config = config;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        DefaultAWSCredentialsProviderChain credentialsProviderChain = new DefaultAWSCredentialsProviderChain(this.config);
        if (this.config.hasPath("gobblin.aws.client.assume.role") && this.config.getBoolean("gobblin.aws.client.assume.role")) {
            String roleArn = this.config.getString("gobblin.aws.client.role.arn");
            String sessionId = this.config.getString("gobblin.aws.client.session.id");
            STSAssumeRoleSessionCredentialsProvider.Builder builder = new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, sessionId).withLongLivedCredentialsProvider((AWSCredentialsProvider)credentialsProviderChain);
            if (this.config.hasPath("gobblin.aws.client.external.id")) {
                builder.withExternalId(this.config.getString("gobblin.aws.client.external.id"));
            }
            if (this.config.hasPath("gobblin.aws.credentials.refresh.interval")) {
                builder.withRoleSessionDurationSeconds((int)TimeUnit.MINUTES.toSeconds(this.config.getLong("gobblin.aws.credentials.refresh.interval")));
            }
            credentialsProviderChain = builder.build();
        }
        return credentialsProviderChain;
    }

    private static class ConfigurationCredentialsProvider
    implements AWSCredentialsProvider {
        private Config config;

        ConfigurationCredentialsProvider(Config config) {
            this.config = config;
        }

        public AWSCredentials getCredentials() {
            String accessKey = null;
            if (this.config.hasPath("gobblin.aws.service.access")) {
                accessKey = this.config.getString("gobblin.aws.service.access");
            }
            String secretKey = null;
            if (this.config.hasPath("gobblin.aws.service.secret")) {
                secretKey = PasswordManager.getInstance((State)ConfigUtils.configToState((Config)this.config)).readPassword(this.config.getString("gobblin.aws.service.secret"));
            }
            accessKey = StringUtils.trim((String)accessKey);
            secretKey = StringUtils.trim(secretKey);
            if (StringUtils.isNullOrEmpty((String)accessKey) || StringUtils.isNullOrEmpty((String)secretKey)) {
                throw new AmazonClientException(String.format("Unable to load AWS credentials from config (%s and %s)", "gobblin.aws.service.access", "gobblin.aws.service.secret"));
            }
            return new BasicAWSCredentials(accessKey, secretKey);
        }

        public void refresh() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class DefaultAWSCredentialsProviderChain
    extends AWSCredentialsProviderChain {
        DefaultAWSCredentialsProviderChain(Config config) {
            super(new AWSCredentialsProvider[]{new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new ConfigurationCredentialsProvider(config), new ProfileCredentialsProvider(), new InstanceProfileCredentialsProvider()});
        }
    }
}

