/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.aws;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.annotation.Alpha;
import org.quartz.utils.FindbugsSuppressWarnings;
import org.slf4j.Logger;

@Alpha
public class GobblinAWSUtils {
    private static final long DEFAULT_EXECUTOR_SERVICE_SHUTDOWN_TIME_IN_MINUTES = 2L;

    public static String appendSlash(String inputString) {
        Preconditions.checkNotNull((Object)inputString);
        if (inputString.endsWith("/")) {
            return inputString;
        }
        return inputString + "/";
    }

    public static String getClasspathFromPaths(File ... paths) {
        Preconditions.checkNotNull((Object)paths);
        StringBuilder classpath = new StringBuilder();
        boolean isFirst = true;
        for (File path : paths) {
            String subClasspath;
            if (!isFirst) {
                classpath.append(":");
            }
            if ((subClasspath = GobblinAWSUtils.getClasspathFromPath(path)).length() <= 0) continue;
            classpath.append(subClasspath);
            isFirst = false;
        }
        return classpath.toString();
    }

    private static String getClasspathFromPath(File path) {
        if (null == path) {
            return "";
        }
        if (!path.isDirectory()) {
            return path.getAbsolutePath();
        }
        return Joiner.on((String)":").skipNulls().join((Object[])path.list((FilenameFilter)FileFileFilter.FILE));
    }

    @FindbugsSuppressWarnings(value={"DM_DEFAULT_ENCODING"})
    public static String encodeBase64(String data) {
        byte[] encodedBytes = Base64.encodeBase64((byte[])data.getBytes());
        return new String(encodedBytes);
    }

    public static void shutdownExecutorService(Class clazz, ExecutorService executorService, Logger logger) throws InterruptedException {
        executorService.shutdown();
        if (!executorService.awaitTermination(2L, TimeUnit.MINUTES)) {
            logger.warn("Executor service shutdown timed out.");
            List<Runnable> pendingTasks = executorService.shutdownNow();
            logger.warn(String.format("%s was shutdown instantly. %s tasks were not executed: %s", clazz.getName(), pendingTasks.size(), StringUtils.join(pendingTasks, (String)",")));
        }
    }
}

