/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.workunit;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Locale;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Extract
extends State {
    private final State previousTableState = new State();

    @Deprecated
    public Extract(SourceState state, TableType type, String namespace, String table) {
        if (state != null && type != null && !Strings.isNullOrEmpty((String)namespace) && !Strings.isNullOrEmpty((String)table)) {
            DateTimeZone timeZone = this.getTimeZoneHelper(state);
            DateTimeFormatter DTF = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss").withLocale(Locale.US).withZone(timeZone);
            String extractId = DTF.print((ReadableInstant)new DateTime());
            super.addAll(state);
            super.setProp("extract.table.type", type.toString());
            super.setProp("extract.namespace", namespace);
            super.setProp("extract.table.name", table);
            super.setProp("extract.extract.id", extractId);
            for (WorkUnitState pre : state.getPreviousWorkUnitStates()) {
                Extract previousExtract = pre.getWorkunit().getExtract();
                if (!previousExtract.getNamespace().equals(namespace) || !previousExtract.getTable().equals(table)) continue;
                this.previousTableState.addAll(pre);
            }
            if (state.getPropAsBoolean("extract.is.full") && !state.contains("extract.full.run.time")) {
                super.setProp("extract.full.run.time", System.currentTimeMillis());
            }
        }
    }

    DateTimeZone getTimeZoneHelper(SourceState state) {
        return DateTimeZone.forID((String)state.getProp("extract.extractIdTimeZone", "UTC"));
    }

    public Extract(TableType type, String namespace, String table) {
        this(new SourceState(), type, namespace, table);
    }

    public Extract(Extract extract) {
        super.addAll(extract.getProperties());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Extract)) {
            return false;
        }
        Extract other = (Extract)object;
        return super.equals(other) && this.getNamespace().equals(other.getNamespace()) && this.getTable().equals(other.getTable()) && this.getExtractId().equals(other.getExtractId());
    }

    @Override
    public int hashCode() {
        return (this.getNamespace() + this.getTable() + this.getExtractId()).hashCode();
    }

    @Deprecated
    public String getOutputFilePath() {
        return this.getNamespace().replaceAll("\\.", "/") + "/" + this.getTable() + "/" + this.getExtractId() + "_" + (this.getIsFull() ? "full" : "append");
    }

    public boolean hasType() {
        return this.contains("extract.table.type");
    }

    public TableType getType() {
        return TableType.valueOf(this.getProp("extract.table.type"));
    }

    public String getNamespace() {
        return this.getProp("extract.namespace", "");
    }

    public String getTable() {
        return this.getProp("extract.table.name", "");
    }

    public String getExtractId() {
        return this.getProp("extract.extract.id", "");
    }

    public void setExtractId(String extractId) {
        this.setProp("extract.extract.id", extractId);
    }

    @Deprecated
    public boolean getIsFull() {
        return this.getPropAsBoolean("extract.is.full", false);
    }

    @Deprecated
    public void setFullTrue(long extractFullRunTime) {
        this.setProp("extract.is.full", true);
        this.setProp("extract.full.run.time", extractFullRunTime);
    }

    @Deprecated
    public void setPrimaryKeys(String ... primaryKeyFieldName) {
        this.setProp("extract.primary.key.fields", Joiner.on((String)",").join((Object[])primaryKeyFieldName));
    }

    @Deprecated
    public void addPrimaryKey(String ... primaryKeyFieldName) {
        StringBuilder sb = new StringBuilder(this.getProp("extract.primary.key.fields", ""));
        Joiner.on((String)",").appendTo(sb, (Object[])primaryKeyFieldName);
        this.setProp("extract.primary.key.fields", sb.toString());
    }

    @Deprecated
    public List<String> getPrimaryKeys() {
        return this.getPropAsList("extract.primary.key.fields");
    }

    @Deprecated
    public void setDeltaFields(String ... deltaFieldName) {
        this.setProp("extract.delta.fields", Joiner.on((String)",").join((Object[])deltaFieldName));
    }

    @Deprecated
    public void addDeltaField(String ... deltaFieldName) {
        StringBuilder sb = new StringBuilder(this.getProp("extract.delta.fields", ""));
        Joiner.on((String)",").appendTo(sb, (Object[])deltaFieldName);
        this.setProp("extract.delta.fields", sb.toString());
    }

    @Deprecated
    public List<String> getDeltaFields() {
        return this.getPropAsList("extract.delta.fields");
    }

    public State getPreviousTableState() {
        return this.previousTableState;
    }

    public static enum TableType {
        SNAPSHOT_ONLY,
        SNAPSHOT_APPEND,
        APPEND_ONLY;

    }
}

