/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.dataset;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.dataset.DatasetDescriptor;
import org.apache.gobblin.dataset.Descriptor;

public class PartitionDescriptor
extends Descriptor {
    private static final Type DESCRIPTOR_LIST_TYPE = new TypeToken<ArrayList<PartitionDescriptor>>(){}.getType();
    private final DatasetDescriptor dataset;

    public PartitionDescriptor(String name, DatasetDescriptor dataset) {
        super(name);
        this.dataset = dataset;
    }

    @Override
    public PartitionDescriptor copy() {
        return new PartitionDescriptor(this.getName(), this.dataset);
    }

    public PartitionDescriptor copyWithNewDataset(DatasetDescriptor dataset) {
        return new PartitionDescriptor(this.getName(), dataset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionDescriptor that = (PartitionDescriptor)o;
        return this.dataset.equals(that.dataset) && this.getName().equals(that.getName());
    }

    public int hashCode() {
        int result = this.dataset.hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public static String toPartitionJsonList(List<PartitionDescriptor> descriptors) {
        return Descriptor.GSON.toJson(descriptors, DESCRIPTOR_LIST_TYPE);
    }

    public static List<PartitionDescriptor> fromPartitionJsonList(String jsonList) {
        return (List)Descriptor.GSON.fromJson(jsonList, DESCRIPTOR_LIST_TYPE);
    }

    public DatasetDescriptor getDataset() {
        return this.dataset;
    }
}

