/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.configuration;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.gobblin.broker.gobblin_scopes.GobblinScopeTypes;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.configuration.CombinedWorkUnitAndDatasetState;
import org.apache.gobblin.configuration.CombinedWorkUnitAndDatasetStateFunctional;
import org.apache.gobblin.configuration.ImmutableWorkUnitState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.workunit.Extract;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SourceState
extends State {
    private static final Set<Extract> EXTRACT_SET = Sets.newConcurrentHashSet();
    private static final DateTimeFormatter DTF = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss").withLocale(Locale.US).withZone(DateTimeZone.UTC);
    private Map<String, SourceState> previousDatasetStatesByUrns;
    private List<WorkUnitState> previousWorkUnitStates = Lists.newArrayList();
    private SharedResourcesBroker<GobblinScopeTypes> broker;
    private CombinedWorkUnitAndDatasetStateFunctional workUnitAndDatasetStateFunctional;
    private boolean areWorkUnitStatesMaterialized;

    public SourceState() {
        this.previousWorkUnitStates = new ArrayList<WorkUnitState>();
        this.previousDatasetStatesByUrns = ImmutableMap.of();
    }

    public SourceState(State properties) {
        super.addAll(properties);
        this.previousWorkUnitStates = new ArrayList<WorkUnitState>();
        this.previousDatasetStatesByUrns = ImmutableMap.of();
    }

    public SourceState(State properties, Iterable<WorkUnitState> previousWorkUnitStates) {
        super.addAll(properties);
        this.previousDatasetStatesByUrns = ImmutableMap.of();
        for (WorkUnitState workUnitState : previousWorkUnitStates) {
            this.previousWorkUnitStates.add(new ImmutableWorkUnitState(workUnitState));
        }
    }

    public SourceState(State properties, Map<String, ? extends SourceState> previousDatasetStatesByUrns, Iterable<WorkUnitState> previousWorkUnitStates) {
        super.addAll(properties.getProperties());
        this.previousDatasetStatesByUrns = ImmutableMap.copyOf(previousDatasetStatesByUrns);
        for (WorkUnitState workUnitState : previousWorkUnitStates) {
            this.previousWorkUnitStates.add(new ImmutableWorkUnitState(workUnitState));
        }
    }

    public SourceState getPreviousSourceState() {
        return this.getPreviousDatasetState("");
    }

    public SourceState getPreviousDatasetState(String datasetUrn) {
        if (!this.previousDatasetStatesByUrns.containsKey(datasetUrn)) {
            return null;
        }
        return new ImmutableSourceState(this.previousDatasetStatesByUrns.get(datasetUrn));
    }

    public Map<String, SourceState> getPreviousDatasetStatesByUrns() {
        if (this.workUnitAndDatasetStateFunctional != null) {
            this.materializeWorkUnitAndDatasetStates(null);
        }
        return this.previousDatasetStatesByUrns;
    }

    public List<WorkUnitState> getPreviousWorkUnitStates() {
        if (this.workUnitAndDatasetStateFunctional != null) {
            this.materializeWorkUnitAndDatasetStates(null);
        }
        return this.previousWorkUnitStates;
    }

    public List<WorkUnitState> getPreviousWorkUnitStates(String datasetUrn) {
        if (this.workUnitAndDatasetStateFunctional != null) {
            try {
                CombinedWorkUnitAndDatasetState state = this.workUnitAndDatasetStateFunctional.getCombinedWorkUnitAndDatasetState(datasetUrn);
                return state.getPreviousWorkUnitStates();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.previousWorkUnitStates;
    }

    public Map<String, Iterable<WorkUnitState>> getPreviousWorkUnitStatesByDatasetUrns() {
        HashMap previousWorkUnitStatesByDatasetUrns = Maps.newHashMap();
        if (this.workUnitAndDatasetStateFunctional != null) {
            this.materializeWorkUnitAndDatasetStates(null);
        }
        for (WorkUnitState workUnitState : this.previousWorkUnitStates) {
            String datasetUrn = workUnitState.getProp("dataset.urn", "");
            if (!previousWorkUnitStatesByDatasetUrns.containsKey(datasetUrn)) {
                previousWorkUnitStatesByDatasetUrns.put(datasetUrn, Lists.newArrayList());
            }
            ((List)previousWorkUnitStatesByDatasetUrns.get(datasetUrn)).add(workUnitState);
        }
        return ImmutableMap.copyOf((Map)previousWorkUnitStatesByDatasetUrns);
    }

    private synchronized void materializeWorkUnitAndDatasetStates(String datasetUrn) {
        if (!this.areWorkUnitStatesMaterialized) {
            try {
                CombinedWorkUnitAndDatasetState workUnitAndDatasetState = this.workUnitAndDatasetStateFunctional.getCombinedWorkUnitAndDatasetState(datasetUrn);
                this.previousWorkUnitStates = workUnitAndDatasetState.getPreviousWorkUnitStates();
                this.previousDatasetStatesByUrns = workUnitAndDatasetState.getPreviousDatasetStatesByUrns();
                this.areWorkUnitStatesMaterialized = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    public synchronized Extract createExtract(Extract.TableType type, String namespace, String table) {
        Extract extract = new Extract(this, type, namespace, table);
        while (EXTRACT_SET.contains(extract)) {
            if (Strings.isNullOrEmpty((String)extract.getExtractId())) {
                extract.setExtractId(DTF.print((ReadableInstant)new DateTime()));
                continue;
            }
            DateTime extractDateTime = DTF.parseDateTime(extract.getExtractId());
            extract.setExtractId(DTF.print((ReadableInstant)extractDateTime.plusSeconds(1)));
        }
        EXTRACT_SET.add(extract);
        return extract;
    }

    @Deprecated
    public WorkUnit createWorkUnit(Extract extract) {
        return new WorkUnit(this, extract);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.write(out, true);
    }

    public void write(DataOutput out, boolean writePreviousWorkUnitStates) throws IOException {
        if (!writePreviousWorkUnitStates) {
            out.writeInt(0);
        } else {
            out.writeInt(this.previousWorkUnitStates.size());
            for (WorkUnitState state : this.previousWorkUnitStates) {
                state.write(out);
            }
        }
        super.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            WorkUnitState workUnitState = new WorkUnitState();
            workUnitState.readFields(in);
            this.previousWorkUnitStates.add(new ImmutableWorkUnitState(workUnitState));
        }
        super.readFields(in);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SourceState)) {
            return false;
        }
        SourceState other = (SourceState)object;
        return super.equals(other) && this.previousDatasetStatesByUrns.equals(other.previousDatasetStatesByUrns) && this.previousWorkUnitStates.equals(other.previousWorkUnitStates);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.previousDatasetStatesByUrns.hashCode();
        result = 31 * result + this.previousWorkUnitStates.hashCode();
        return result;
    }

    public SharedResourcesBroker<GobblinScopeTypes> getBroker() {
        return this.broker;
    }

    public void setBroker(SharedResourcesBroker<GobblinScopeTypes> broker) {
        this.broker = broker;
    }

    public CombinedWorkUnitAndDatasetStateFunctional getWorkUnitAndDatasetStateFunctional() {
        return this.workUnitAndDatasetStateFunctional;
    }

    public void setWorkUnitAndDatasetStateFunctional(CombinedWorkUnitAndDatasetStateFunctional workUnitAndDatasetStateFunctional) {
        this.workUnitAndDatasetStateFunctional = workUnitAndDatasetStateFunctional;
    }

    private static class ImmutableSourceState
    extends SourceState {
        public ImmutableSourceState(SourceState sourceState) {
            super(sourceState, sourceState.previousDatasetStatesByUrns, sourceState.previousWorkUnitStates);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setId(String id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setProp(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void appendToListProp(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(State otherState) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAll(Properties properties) {
            throw new UnsupportedOperationException();
        }
    }
}

