/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.workunit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.source.workunit.WorkUnit;

public class MultiWorkUnit
extends WorkUnit {
    private final List<WorkUnit> workUnits = Lists.newArrayList();

    @Deprecated
    public MultiWorkUnit() {
    }

    public List<WorkUnit> getWorkUnits() {
        return ImmutableList.builder().addAll(this.workUnits).build();
    }

    public void addWorkUnit(WorkUnit workUnit) {
        this.workUnits.add(workUnit);
    }

    public void addWorkUnits(Collection<WorkUnit> workUnits) {
        this.workUnits.addAll(workUnits);
    }

    @Override
    public void setProp(String key, Object value) {
        super.setProp(key, value);
        for (WorkUnit workUnit : this.workUnits) {
            workUnit.setProp(key, value);
        }
    }

    public void setPropExcludeInnerWorkUnits(String key, Object value) {
        super.setProp(key, value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int numWorkUnits = in.readInt();
        for (int i = 0; i < numWorkUnits; ++i) {
            WorkUnit workUnit = WorkUnit.createEmpty();
            workUnit.readFields(in);
            this.workUnits.add(workUnit);
        }
        super.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.workUnits.size());
        for (WorkUnit workUnit : this.workUnits) {
            workUnit.write(out);
        }
        super.write(out);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MultiWorkUnit)) {
            return false;
        }
        MultiWorkUnit other = (MultiWorkUnit)object;
        return super.equals(other) && this.workUnits.equals(other.workUnits);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.workUnits == null ? 0 : this.workUnits.hashCode());
        return result;
    }

    public static MultiWorkUnit createEmpty() {
        return new MultiWorkUnit();
    }

    @Override
    public String toString() {
        return "MultiWorkUnit(super=" + super.toString() + ", workUnits=" + this.getWorkUnits() + ")";
    }
}

