/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.dataset;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.util.io.GsonInterfaceAdapter;

public class Descriptor {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonInterfaceAdapter(Descriptor.class)).create();
    private static final Type DESCRIPTOR_LIST_TYPE = new TypeToken<ArrayList<Descriptor>>(){}.getType();
    private final String name;

    public String toString() {
        return GSON.toJson((Object)this);
    }

    public Descriptor copy() {
        return new Descriptor(this.name);
    }

    public static String toJson(Descriptor descriptor) {
        return GSON.toJson((Object)descriptor);
    }

    public static Descriptor fromJson(String json) {
        return Descriptor.fromJson(json, Descriptor.class);
    }

    public static <T extends Descriptor> T fromJson(String json, Class<T> clazz) {
        return (T)((Descriptor)GSON.fromJson(json, clazz));
    }

    public static String toJson(List<Descriptor> descriptors) {
        return GSON.toJson(descriptors, DESCRIPTOR_LIST_TYPE);
    }

    public static List<Descriptor> fromJsonList(String jsonList) {
        return (List)GSON.fromJson(jsonList, DESCRIPTOR_LIST_TYPE);
    }

    @ConstructorProperties(value={"name"})
    public Descriptor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

