/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.commit;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.commit.CommitStep;
import org.apache.gobblin.commit.CommitStepBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class CommitSequence {
    private static final Logger log = LoggerFactory.getLogger(CommitSequence.class);
    private final String jobName;
    private final String datasetUrn;
    private final List<CommitStep> steps;

    private CommitSequence(Builder builder) {
        this.jobName = builder.jobName;
        this.datasetUrn = builder.datasetUrn;
        this.steps = ImmutableList.copyOf((Collection)builder.steps);
    }

    public void execute() {
        try {
            for (CommitStep step : this.steps) {
                if (step.isCompleted()) continue;
                step.execute();
            }
        }
        catch (Throwable t) {
            log.error("Commit failed for dataset " + this.datasetUrn, t);
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getDatasetUrn() {
        return this.datasetUrn;
    }

    public static class Builder {
        private String jobName;
        private String datasetUrn;
        private final List<CommitStep> steps = Lists.newArrayList();

        public Builder withJobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder withDatasetUrn(String datasetUrn) {
            this.datasetUrn = datasetUrn;
            return this;
        }

        public <T extends CommitStepBase.Builder<?>> T beginStep(Class<T> builderClass) {
            try {
                return (T)((CommitStepBase.Builder)builderClass.getDeclaredConstructor(this.getClass()).newInstance(this));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to instantiate " + builderClass, e);
            }
        }

        public Builder addStep(CommitStep step) {
            this.steps.add(step);
            return this;
        }

        public CommitSequence build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.jobName) ? 1 : 0) != 0, (Object)"Job name not specified for commit sequence");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.datasetUrn) ? 1 : 0) != 0, (Object)"Dataset URN not specified for commit sequence");
            Preconditions.checkState((!this.steps.isEmpty() ? 1 : 0) != 0, (Object)"No commit steps specified for the commit sequence");
            return new CommitSequence(this);
        }
    }
}

