/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo.server;

import java.io.File;
import org.apache.geronimo.mavenplugins.geronimo.ServerProxy;
import org.apache.geronimo.mavenplugins.geronimo.reporting.ReportingMojoSupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.plexus.util.FileUtils;

public class RunClientMojo
extends ReportingMojoSupport {
    protected String moduleId = null;
    private String maximumMemory = null;
    private File javaVirtualMachine;
    private int timeout = -1;
    protected String[] arg = null;

    protected void doExecute() throws Exception {
        ServerProxy server = new ServerProxy(this.hostname, this.port, this.username, this.password);
        String geronimoHomeStr = server.getGeronimoHome();
        this.log.info((CharSequence)("Geronimo Home: " + geronimoHomeStr));
        if (geronimoHomeStr == null) {
            throw new MojoExecutionException("Unable to determine Geronimo installation directory");
        }
        File geronimoHome = new File(geronimoHomeStr);
        if (!geronimoHome.exists()) {
            throw new MojoExecutionException("Geronimo installation directory does not exist: " + geronimoHomeStr);
        }
        this.log.info((CharSequence)"Starting Geronimo client...");
        Java java = (Java)this.createTask("java");
        java.setJar(new File(geronimoHome, "bin/client.jar"));
        java.setDir(geronimoHome);
        java.setFailonerror(true);
        java.setFork(true);
        if (this.javaVirtualMachine != null) {
            if (!this.javaVirtualMachine.exists()) {
                throw new MojoExecutionException("Java virtual machine is not valid: " + this.javaVirtualMachine);
            }
            this.log.info((CharSequence)("Using Java virtual machine: " + this.javaVirtualMachine));
            java.setJvm(this.javaVirtualMachine.getCanonicalPath());
        }
        if (this.timeout > 0) {
            java.setTimeout(new Long(this.timeout * 1000));
        }
        if (this.maximumMemory != null) {
            java.setMaxmemory(this.maximumMemory);
        }
        this.setSystemProperty(java, "org.apache.geronimo.base.dir", geronimoHome);
        this.setSystemProperty(java, "java.io.tmpdir", "var/temp");
        this.setSystemProperty(java, "java.endorsed.dirs", this.prefixSystemPath("java.endorsed.dirs", new File(geronimoHome, "lib/endorsed")));
        this.setSystemProperty(java, "java.ext.dirs", this.prefixSystemPath("java.ext.dirs", new File(geronimoHome, "lib/ext")));
        java.createArg().setValue(this.moduleId);
        for (int i = 0; this.arg != null && i < this.arg.length; ++i) {
            java.createArg().setValue(this.arg[i]);
        }
        if (this.logOutput) {
            File file = this.getLogFile();
            FileUtils.forceMkdir((File)file.getParentFile());
            this.log.info((CharSequence)("Redirecting output to: " + file));
            java.setOutput(file);
        }
        java.execute();
    }

    private String prefixSystemPath(String name, File file) {
        assert (name != null);
        assert (file != null);
        String dirs = file.getPath();
        String prop = System.getProperty(name, "");
        if (prop.length() > 0) {
            dirs = dirs + File.pathSeparator;
            dirs = dirs + prop;
        }
        return dirs;
    }

    protected String getFullClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

