/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mavenplugins.geronimo.module;

import java.io.IOException;
import java.util.ArrayList;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.deployment.plugin.factories.DeploymentFactoryImpl;
import org.apache.geronimo.mavenplugins.geronimo.ModuleConfig;
import org.apache.geronimo.mavenplugins.geronimo.reporting.ReportingMojoSupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

public abstract class ModuleMojoSupport
extends ReportingMojoSupport {
    private static final String URI_PREFIX = "deployer:geronimo:jmx";
    protected ModuleConfig[] modules;
    private DeploymentManager deploymentManager;
    protected boolean stopOnFailure = false;

    protected DeploymentManager getDeploymentManager() throws IOException, DeploymentManagerCreationException {
        if (this.deploymentManager == null) {
            DeploymentFactoryManager manager = DeploymentFactoryManager.getInstance();
            manager.registerDeploymentFactory((DeploymentFactory)new DeploymentFactoryImpl());
            String uri = "deployer:geronimo:jmx://" + this.hostname + ":" + this.port;
            DeploymentFactoryManager factoryManager = DeploymentFactoryManager.getInstance();
            this.deploymentManager = factoryManager.getDeploymentManager(uri, this.username, this.password);
        }
        return this.deploymentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeploymentStatus waitFor(final ProgressObject progress) throws InterruptedException {
        assert (progress != null);
        ProgressListener listener = new ProgressListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleProgressEvent(ProgressEvent event) {
                DeploymentStatus status = event.getDeploymentStatus();
                if (!status.isRunning()) {
                    ProgressObject progressObject = progress;
                    synchronized (progressObject) {
                        progress.notify();
                    }
                }
            }
        };
        progress.addProgressListener(listener);
        ProgressObject progressObject = progress;
        synchronized (progressObject) {
            while (progress.getDeploymentStatus().isRunning()) {
                progress.wait();
            }
        }
        return progress.getDeploymentStatus();
    }

    protected String getModuleId(ArtifactItem item) {
        assert (item != null);
        return item.getGroupId() + "/" + item.getArtifactId() + "/" + item.getVersion() + "/" + item.getType();
    }

    protected TargetModuleID[] getNonRunningModules(TargetModuleID[] moduleIds) throws Exception {
        assert (moduleIds != null);
        ArrayList<TargetModuleID> modulesList = new ArrayList<TargetModuleID>();
        DeploymentManager manager = this.getDeploymentManager();
        Target[] targets = manager.getTargets();
        TargetModuleID[] runningModuleIds = manager.getRunningModules(null, targets);
        for (int j = 0; j < moduleIds.length; ++j) {
            String moduleId = moduleIds[j].getModuleID();
            this.log.debug((CharSequence)("Checking if module is running: " + moduleId));
            boolean found = false;
            for (int i = 0; i < runningModuleIds.length; ++i) {
                String runningModuleId = runningModuleIds[i].getModuleID();
                if (!moduleId.equals(runningModuleId)) continue;
                this.log.debug((CharSequence)("Module is running: " + moduleId));
                found = true;
                break;
            }
            if (found) continue;
            this.log.debug((CharSequence)("Module is not running: " + moduleId));
            modulesList.add(moduleIds[j]);
        }
        return modulesList.toArray(new TargetModuleID[modulesList.size()]);
    }

    protected boolean isModuleStarted(String moduleId) throws Exception {
        assert (moduleId != null);
        this.log.debug((CharSequence)("Checking if module is started: " + moduleId));
        DeploymentManager manager = this.getDeploymentManager();
        Target[] targets = manager.getTargets();
        TargetModuleID[] targetIds = manager.getRunningModules(null, targets);
        for (int i = 0; i < targetIds.length; ++i) {
            if (!moduleId.equals(targetIds[i].getModuleID())) continue;
            return true;
        }
        return false;
    }

    protected TargetModuleID[] findModules(String moduleId, TargetModuleID[] targetIds) {
        assert (moduleId != null);
        assert (targetIds != null);
        ArrayList<TargetModuleID> found = new ArrayList<TargetModuleID>();
        this.log.debug((CharSequence)("Scanning for modules that match: " + moduleId));
        for (int i = 0; i < targetIds.length; ++i) {
            this.log.debug((CharSequence)("Checking: " + targetIds[i].getModuleID()));
            if (!moduleId.equals(targetIds[i].getModuleID())) continue;
            found.add(targetIds[i]);
        }
        return found.toArray(new TargetModuleID[found.size()]);
    }

    protected void startModule() throws Exception {
        assert (this.modules != null);
        for (int i = 0; i < this.modules.length; ++i) {
            Target[] targets;
            String moduleId = this.getModuleId(this.modules[i]);
            if (this.isModuleStarted(moduleId)) {
                this.log.warn((CharSequence)("Module is already started: " + moduleId));
                continue;
            }
            DeploymentManager manager = this.getDeploymentManager();
            TargetModuleID[] targetIds = manager.getNonRunningModules(null, targets = manager.getTargets());
            TargetModuleID[] found = this.findModules(moduleId, targetIds);
            if (found.length == 0) {
                throw new MojoExecutionException("Module is not deployed: " + moduleId);
            }
            this.log.info((CharSequence)("Starting module: " + moduleId));
            ProgressObject progress = manager.start(found);
            DeploymentStatus status = this.waitFor(progress);
            if (status.isFailed()) {
                throw new MojoExecutionException("Failed to start module: " + moduleId);
            }
            this.log.info((CharSequence)"Started module(s):");
            this.logModules(found, "    ");
        }
    }

    protected void stopModule() throws Exception {
        assert (this.modules != null);
        DeploymentManager manager = this.getDeploymentManager();
        Target[] targets = manager.getTargets();
        TargetModuleID[] targetIds = manager.getRunningModules(null, targets);
        for (int i = 0; i < this.modules.length; ++i) {
            String moduleId = this.getModuleId(this.modules[i]);
            if (!this.isModuleStarted(moduleId)) {
                this.log.info((CharSequence)("Module is already stopped: " + moduleId));
                continue;
            }
            TargetModuleID[] found = this.findModules(moduleId, targetIds);
            if (found.length == 0) {
                throw new MojoExecutionException("Module not deployed: " + moduleId);
            }
            this.log.info((CharSequence)("Stopping module: " + moduleId));
            ProgressObject progress = manager.stop(found);
            DeploymentStatus status = this.waitFor(progress);
            if (status.isFailed()) {
                throw new MojoExecutionException("Failed to stop module: " + moduleId);
            }
            this.log.info((CharSequence)"Stopped module(s):");
            this.logModules(found, "    ");
        }
    }

    protected void undeployModule() throws Exception {
        assert (this.modules != null);
        this.stopModule();
        DeploymentManager manager = this.getDeploymentManager();
        Target[] targets = manager.getTargets();
        TargetModuleID[] targetIds = manager.getNonRunningModules(null, targets);
        for (int i = 0; i < this.modules.length; ++i) {
            String moduleId = this.getModuleId(this.modules[i]);
            TargetModuleID[] found = this.findModules(moduleId, targetIds);
            if (found.length == 0) {
                this.log.info((CharSequence)("Module is not deployed: " + moduleId));
                continue;
            }
            this.log.info((CharSequence)("Undeploying module: " + moduleId));
            ProgressObject progress = manager.undeploy(found);
            DeploymentStatus status = this.waitFor(progress);
            if (status.isFailed()) {
                throw new MojoExecutionException("Failed to undeploy module: " + moduleId);
            }
            this.log.info((CharSequence)"Undeployed module(s):");
            this.logModules(found, "    ");
        }
    }

    protected void logModules(TargetModuleID[] targetIds) {
        this.logModules(targetIds, "");
    }

    protected void logModules(TargetModuleID[] targetIds, String pad) {
        assert (targetIds != null);
        assert (pad != null);
        for (int i = 0; i < targetIds.length; ++i) {
            String url = targetIds[i].getWebURL();
            this.log.info((CharSequence)(pad + "[" + i + "] " + targetIds[i].getModuleID() + (url == null ? "" : "; URL: " + url)));
            TargetModuleID[] children = targetIds[i].getChildTargetModuleID();
            if (children == null) continue;
            this.logModules(children, pad + "    ");
        }
    }
}

