/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.rpc.server.ServiceLifecycle;
import org.apache.geronimo.webservices.ServiceLifecycleManager;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;

public class POJOWebServiceServlet
implements Servlet {
    public static final String POJO_CLASS = POJOWebServiceServlet.class.getName() + "@pojoClassName";
    private Servlet stack;

    public void init(ServletConfig config) throws ServletException {
        Object pojo;
        ServletContext context = config.getServletContext();
        String pojoClassID = config.getInitParameter(POJO_CLASS);
        Class pojoClass = (Class)context.getAttribute(pojoClassID);
        try {
            pojo = pojoClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Unable to instantiate POJO WebService class: " + pojoClass.getName(), (Throwable)e);
        }
        this.stack = new WebServiceContainerInvoker(pojo);
        if (pojo instanceof ServiceLifecycle) {
            this.stack = new ServiceLifecycleManager(this.stack, (ServiceLifecycle)pojo);
        }
        this.stack.init(config);
    }

    public ServletConfig getServletConfig() {
        return this.stack.getServletConfig();
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.stack.service(servletRequest, servletResponse);
    }

    public String getServletInfo() {
        return this.stack.getServletInfo();
    }

    public void destroy() {
        this.stack.destroy();
    }
}

