/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.builder;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.holders.BigDecimalHolder;
import javax.xml.rpc.holders.BigIntegerHolder;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.CalendarHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.QNameHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.webservices.builder.DescriptorVersion;
import org.apache.geronimo.webservices.builder.PortInfo;
import org.apache.geronimo.webservices.builder.SharedPortInfo;
import org.apache.geronimo.xbeans.j2ee.ExceptionMappingType;
import org.apache.geronimo.xbeans.j2ee.JavaWsdlMappingDocument;
import org.apache.geronimo.xbeans.j2ee.JavaWsdlMappingType;
import org.apache.geronimo.xbeans.j2ee.PackageMappingType;
import org.apache.geronimo.xbeans.j2ee.ParamValueType;
import org.apache.geronimo.xbeans.j2ee.PortComponentHandlerType;
import org.apache.geronimo.xbeans.j2ee.PortComponentType;
import org.apache.geronimo.xbeans.j2ee.ServiceEndpointInterfaceMappingType;
import org.apache.geronimo.xbeans.j2ee.ServiceEndpointMethodMappingType;
import org.apache.geronimo.xbeans.j2ee.WebserviceDescriptionType;
import org.apache.geronimo.xbeans.j2ee.WebservicesType;
import org.apache.geronimo.xbeans.j2ee.XsdQNameType;
import org.apache.geronimo.xbeans.javaee6.ServiceImplBeanType;
import org.apache.geronimo.xbeans.javaee6.WebservicesDocument;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;

public class WSDescriptorParser {
    private static final Map<Class, Class> rpcHolderClasses = new HashMap<Class, Class>();

    public static JavaWsdlMappingType readJaxrpcMapping(JarFile moduleFile, URI jaxrpcMappingURI) throws DeploymentException {
        String jaxrpcMappingPath = jaxrpcMappingURI.toString();
        return WSDescriptorParser.readJaxrpcMapping(moduleFile, jaxrpcMappingPath);
    }

    public static JavaWsdlMappingType readJaxrpcMapping(JarFile moduleFile, String jaxrpcMappingPath) throws DeploymentException {
        JavaWsdlMappingDocument mappingDocument;
        InputStream jaxrpcInputStream;
        try {
            ZipEntry zipEntry = moduleFile.getEntry(jaxrpcMappingPath);
            if (zipEntry == null) {
                throw new DeploymentException("The JAX-RPC mapping file " + jaxrpcMappingPath + " specified in webservices.xml could not be found.");
            }
            jaxrpcInputStream = moduleFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new DeploymentException("Could not open stream to jaxrpc mapping document", (Throwable)e);
        }
        try {
            mappingDocument = JavaWsdlMappingDocument.Factory.parse((InputStream)jaxrpcInputStream);
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not parse jaxrpc mapping document", (Throwable)e);
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read jaxrpc mapping document", (Throwable)e);
        }
        JavaWsdlMappingType mapping = mappingDocument.getJavaWsdlMapping();
        return mapping;
    }

    public static Map<QName, ExceptionMappingType> getExceptionMap(JavaWsdlMappingType mapping) {
        HashMap<QName, ExceptionMappingType> exceptionMap = new HashMap<QName, ExceptionMappingType>();
        if (mapping != null) {
            ExceptionMappingType[] exceptionMappings;
            for (ExceptionMappingType exceptionMapping : exceptionMappings = mapping.getExceptionMappingArray()) {
                QName exceptionMessageQName = exceptionMapping.getWsdlMessage().getQNameValue();
                exceptionMap.put(exceptionMessageQName, exceptionMapping);
            }
        }
        return exceptionMap;
    }

    public static String getPackageFromNamespace(String namespace, JavaWsdlMappingType mapping) throws DeploymentException {
        PackageMappingType[] packageMappings;
        for (PackageMappingType packageMapping : packageMappings = mapping.getPackageMappingArray()) {
            if (!namespace.equals(packageMapping.getNamespaceURI().getStringValue().trim())) continue;
            return packageMapping.getPackageType().getStringValue().trim();
        }
        throw new DeploymentException("Namespace " + namespace + " was not mapped in jaxrpc mapping file");
    }

    public static Class getHolderType(String paramJavaTypeName, boolean isInOnly, QName typeQName, boolean isComplexType, JavaWsdlMappingType mapping, Bundle bundle) throws DeploymentException {
        String holderName;
        if (isInOnly) {
            Class paramJavaType;
            try {
                paramJavaType = ClassLoading.loadClass((String)paramJavaTypeName, (Bundle)bundle);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load parameter type", (Throwable)e);
            }
            return paramJavaType;
        }
        if (isComplexType) {
            String namespace = typeQName.getNamespaceURI();
            String packageName = WSDescriptorParser.getPackageFromNamespace(namespace, mapping);
            StringBuffer buf = new StringBuffer(packageName.length() + typeQName.getLocalPart().length() + 14);
            buf.append(packageName).append(".holders.").append(typeQName.getLocalPart()).append("Holder");
            buf.setCharAt(packageName.length() + 9, Character.toUpperCase(typeQName.getLocalPart().charAt(0)));
            holderName = buf.toString();
        } else {
            Class paramJavaType;
            try {
                paramJavaType = ClassLoading.loadClass((String)paramJavaTypeName, (Bundle)bundle);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("could not load parameter type", (Throwable)e);
            }
            Class holder = rpcHolderClasses.get(paramJavaType);
            if (holder != null) {
                try {
                    holder = ClassLoading.loadClass((String)holder.getName(), (Bundle)bundle);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException("could not load holder type in correct classloader", (Throwable)e);
                }
                return holder;
            }
            String paramTypeName = paramJavaType.getName();
            StringBuffer buf = new StringBuffer(paramTypeName.length() + 14);
            int dot = paramTypeName.lastIndexOf(".");
            buf.append(paramTypeName.substring(0, dot)).append(".holders").append(paramTypeName.substring(dot)).append("Holder");
            holderName = buf.toString();
        }
        try {
            return ClassLoading.loadClass((String)holderName, (Bundle)bundle);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load holder class", (Throwable)e);
        }
    }

    public static ServiceEndpointMethodMappingType getMethodMappingForOperation(String operationName, ServiceEndpointMethodMappingType[] methodMappings) throws DeploymentException {
        for (ServiceEndpointMethodMappingType methodMapping : methodMappings) {
            if (!operationName.equals(methodMapping.getWsdlOperation().getStringValue())) continue;
            return methodMapping;
        }
        StringBuffer availOps = new StringBuffer(128);
        for (int i = 0; i < methodMappings.length; ++i) {
            if (i != 0) {
                availOps.append(",");
            }
            availOps.append(methodMappings[i].getWsdlOperation().getStringValue());
        }
        throw new DeploymentException("No method found for operation named '" + operationName + "'. Available operations: " + availOps);
    }

    public static ServiceEndpointInterfaceMappingType getServiceEndpointInterfaceMapping(ServiceEndpointInterfaceMappingType[] endpointMappings, QName portTypeQName) throws DeploymentException {
        for (ServiceEndpointInterfaceMappingType endpointMapping : endpointMappings) {
            QName testPortQName = endpointMapping.getWsdlPortType().getQNameValue();
            if (!portTypeQName.equals(testPortQName)) continue;
            return endpointMapping;
        }
        throw new DeploymentException("Could not find service endpoint interface for port named " + portTypeQName);
    }

    public static Service getService(QName serviceQName, Definition definition) throws DeploymentException {
        Service service;
        if (serviceQName != null) {
            service = definition.getService(serviceQName);
        } else {
            Map services = definition.getServices();
            if (services.size() != 1) {
                throw new DeploymentException("no serviceQName supplied, and there are " + services.size() + " services");
            }
            service = (Service)services.values().iterator().next();
        }
        if (service == null) {
            throw new DeploymentException("No service wsdl for supplied service qname " + serviceQName);
        }
        return service;
    }

    public static Method getMethodForOperation(Class serviceEndpointInterface, Operation operation) throws DeploymentException {
        Method[] methods = serviceEndpointInterface.getMethods();
        String opName = operation.getName();
        Method found = null;
        for (Method method : methods) {
            if (!method.getName().equals(opName)) continue;
            if (found != null) {
                throw new DeploymentException("Overloaded methods are not allowed in lightweight mappings");
            }
            found = method;
        }
        if (found == null) {
            throw new DeploymentException("No method found for operation named " + opName);
        }
        return found;
    }

    public static Map<String, PortInfo> parseWebServiceDescriptor(WebservicesType webservicesType, JarFile moduleFile, boolean isEJB, Map servletLocations) throws DeploymentException {
        WebserviceDescriptionType[] webserviceDescriptions;
        HashMap<String, PortInfo> portMap = new HashMap<String, PortInfo>();
        for (WebserviceDescriptionType webserviceDescription : webserviceDescriptions = webservicesType.getWebserviceDescriptionArray()) {
            PortComponentType[] portComponents;
            String wsdlLocation = webserviceDescription.getWsdlFile().getStringValue().trim();
            String jaxrpcMappingFile = webserviceDescription.getJaxrpcMappingFile().getStringValue().trim();
            SharedPortInfo sharedPortInfo = new SharedPortInfo(wsdlLocation, jaxrpcMappingFile, DescriptorVersion.J2EE);
            for (PortComponentType portComponent : portComponents = webserviceDescription.getPortComponentArray()) {
                PortComponentHandlerType[] handlers;
                PortInfo portInfo;
                String servletLocation;
                String linkName;
                String portComponentName = portComponent.getPortComponentName().getStringValue().trim();
                QName portQName = portComponent.getWsdlPort().getQNameValue();
                String seiInterfaceName = portComponent.getServiceEndpointInterface().getStringValue().trim();
                org.apache.geronimo.xbeans.j2ee.ServiceImplBeanType serviceImplBeanType = portComponent.getServiceImplBean();
                if (isEJB == serviceImplBeanType.isSetServletLink()) {
                    throw new DeploymentException("Wrong kind of web service described in web service descriptor: expected " + (isEJB ? "EJB" : "POJO(Servlet)"));
                }
                if (serviceImplBeanType.isSetServletLink()) {
                    linkName = serviceImplBeanType.getServletLink().getStringValue().trim();
                    servletLocation = (String)servletLocations.get(linkName);
                    if (servletLocation == null) {
                        throw new DeploymentException("No servlet mapping for port " + portComponentName);
                    }
                } else {
                    linkName = serviceImplBeanType.getEjbLink().getStringValue().trim();
                    servletLocation = (String)servletLocations.get(linkName);
                }
                if (portMap.put(linkName, portInfo = new PortInfo(sharedPortInfo, portComponentName, portQName, seiInterfaceName, handlers = portComponent.getHandlerArray(), servletLocation)) == null) continue;
                throw new DeploymentException("Ambiguous description of port associated with j2ee component " + linkName);
            }
        }
        return portMap;
    }

    public static Map<String, PortInfo> parseWebServiceDescriptor(org.apache.geronimo.xbeans.javaee6.WebservicesType webservicesType, JarFile moduleFile, boolean isEJB, Map servletLocations) throws DeploymentException {
        org.apache.geronimo.xbeans.javaee6.WebserviceDescriptionType[] webserviceDescriptions;
        HashMap<String, PortInfo> portMap = new HashMap<String, PortInfo>();
        for (org.apache.geronimo.xbeans.javaee6.WebserviceDescriptionType webserviceDescription : webserviceDescriptions = webservicesType.getWebserviceDescriptionArray()) {
            org.apache.geronimo.xbeans.javaee6.PortComponentType[] portComponents;
            String wsdlLocation = null;
            if (webserviceDescription.isSetWsdlFile()) {
                wsdlLocation = webserviceDescription.getWsdlFile().getStringValue().trim();
            }
            String jaxrpcMappingFile = null;
            if (webserviceDescription.isSetJaxrpcMappingFile()) {
                jaxrpcMappingFile = webserviceDescription.getJaxrpcMappingFile().getStringValue().trim();
            }
            SharedPortInfo sharedPortInfo = new SharedPortInfo(wsdlLocation, jaxrpcMappingFile, DescriptorVersion.JAVAEE);
            for (org.apache.geronimo.xbeans.javaee6.PortComponentType portComponent : portComponents = webserviceDescription.getPortComponentArray()) {
                PortInfo portInfo;
                String servletLocation;
                String linkName;
                ServiceImplBeanType serviceImplBeanType;
                String portComponentName = portComponent.getPortComponentName().getStringValue().trim();
                QName portQName = null;
                if (portComponent.isSetWsdlPort()) {
                    portQName = portComponent.getWsdlPort().getQNameValue();
                }
                String seiInterfaceName = null;
                if (portComponent.isSetServiceEndpointInterface()) {
                    seiInterfaceName = portComponent.getServiceEndpointInterface().getStringValue().trim();
                }
                if (isEJB == (serviceImplBeanType = portComponent.getServiceImplBean()).isSetServletLink()) {
                    throw new DeploymentException("Wrong kind of web service described in web service descriptor: expected " + (isEJB ? "EJB" : "POJO(Servlet)"));
                }
                if (serviceImplBeanType.isSetServletLink()) {
                    linkName = serviceImplBeanType.getServletLink().getStringValue().trim();
                    servletLocation = (String)servletLocations.get(linkName);
                    if (servletLocation == null) {
                        throw new DeploymentException("No servlet mapping for port " + portComponentName);
                    }
                } else {
                    linkName = serviceImplBeanType.getEjbLink().getStringValue().trim();
                    servletLocation = (String)servletLocations.get(linkName);
                }
                PortComponentHandlerType[] handlers = null;
                if (portComponent.getHandlerArray() != null) {
                    handlers = new PortComponentHandlerType[portComponent.getHandlerArray().length];
                    for (int i = 0; i < portComponent.getHandlerArray().length; ++i) {
                        handlers[i] = (PortComponentHandlerType)portComponent.getHandlerArray()[i].changeType(PortComponentHandlerType.type);
                    }
                }
                if (portMap.put(linkName, portInfo = new PortInfo(sharedPortInfo, portComponentName, portQName, seiInterfaceName, handlers, servletLocation)) == null) continue;
                throw new DeploymentException("Ambiguous description of port associated with j2ee component " + linkName);
            }
        }
        return portMap;
    }

    public static Map<String, PortInfo> parseWebServiceDescriptor(URL wsDDUrl, JarFile moduleFile, boolean isEJB, Map servletLocations) throws DeploymentException {
        XmlObject webservicesType = WSDescriptorParser.getWebservicesType(wsDDUrl);
        if (webservicesType instanceof WebservicesType) {
            WebservicesType webServices = (WebservicesType)webservicesType;
            return WSDescriptorParser.parseWebServiceDescriptor(webServices, moduleFile, isEJB, servletLocations);
        }
        if (webservicesType instanceof org.apache.geronimo.xbeans.javaee6.WebservicesType) {
            org.apache.geronimo.xbeans.javaee6.WebservicesType webServices = (org.apache.geronimo.xbeans.javaee6.WebservicesType)webservicesType;
            return WSDescriptorParser.parseWebServiceDescriptor(webServices, moduleFile, isEJB, servletLocations);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static XmlObject getWebservicesType(URL wsDDUrl) throws DeploymentException {
        try {
            XmlObject webservicesDocumentUntyped = XmlObject.Factory.parse((URL)wsDDUrl);
            XmlCursor cursor = webservicesDocumentUntyped.newCursor();
            try {
                if (cursor.currentTokenType() != XmlCursor.TokenType.START) {
                    while (cursor.toNextToken() != XmlCursor.TokenType.START) {
                    }
                }
                QName qname = cursor.getName();
                if (org.apache.geronimo.xbeans.j2ee.WebservicesDocument.type.getDocumentElementName().equals(qname)) {
                    XmlObject xmlObject = WSDescriptorParser.getJ2EEWebServices(webservicesDocumentUntyped);
                    return xmlObject;
                }
                if (WebservicesDocument.type.getDocumentElementName().equals(qname)) {
                    XmlObject xmlObject = WSDescriptorParser.getJavaEEWebServices(webservicesDocumentUntyped);
                    return xmlObject;
                }
                XmlObject xmlObject = null;
                return xmlObject;
            }
            finally {
                cursor.dispose();
            }
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not read descriptor document", (Throwable)e);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static XmlObject getJ2EEWebServices(XmlObject webservicesDocumentUntyped) throws XmlException {
        org.apache.geronimo.xbeans.j2ee.WebservicesDocument webservicesDocument = webservicesDocumentUntyped instanceof org.apache.geronimo.xbeans.j2ee.WebservicesDocument ? (org.apache.geronimo.xbeans.j2ee.WebservicesDocument)webservicesDocumentUntyped : (org.apache.geronimo.xbeans.j2ee.WebservicesDocument)webservicesDocumentUntyped.changeType(org.apache.geronimo.xbeans.j2ee.WebservicesDocument.type);
        XmlBeansUtil.validateDD((XmlObject)webservicesDocument);
        return webservicesDocument.getWebservices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XmlObject getJavaEEWebServices(XmlObject webservicesDocumentUntyped) throws XmlException {
        XmlCursor cursor = null;
        try {
            cursor = webservicesDocumentUntyped.newCursor();
            cursor.toStartDoc();
            cursor.toFirstChild();
            SchemaConversionUtils.convertSchemaVersion((XmlCursor)cursor, (String)"http://java.sun.com/xml/ns/javaee", (String)"http://java.sun.com/xml/ns/javaee/javaee_web_services_1_3.xsd", (String)"1.3");
            XmlObject result = webservicesDocumentUntyped.changeType(WebservicesDocument.type);
            XmlBeansUtil.validateDD((XmlObject)result);
            WebservicesDocument webservicesDocument = (WebservicesDocument)result;
            org.apache.geronimo.xbeans.javaee6.WebservicesType webservicesType = webservicesDocument.getWebservices();
            return webservicesType;
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.dispose();
                }
                catch (Exception e) {}
            }
        }
    }

    public static List<HandlerInfo> createHandlerInfoList(PortComponentHandlerType[] handlers, Bundle bundle) throws DeploymentException {
        ArrayList<HandlerInfo> list = new ArrayList<HandlerInfo>();
        for (PortComponentHandlerType handler : handlers) {
            ParamValueType[] paramValues;
            Class handlerClass;
            String className = handler.getHandlerClass().getStringValue().trim();
            try {
                handlerClass = bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Unable to load handler class: " + className, (Throwable)e);
            }
            HashMap<String, String> config = new HashMap<String, String>();
            for (ParamValueType paramValue : paramValues = handler.getInitParamArray()) {
                String paramName = paramValue.getParamName().getStringValue().trim();
                String paramStringValue = paramValue.getParamValue().getStringValue().trim();
                config.put(paramName, paramStringValue);
            }
            XsdQNameType[] soapHeaderQNames = handler.getSoapHeaderArray();
            QName[] headers = new QName[soapHeaderQNames.length];
            for (int j = 0; j < soapHeaderQNames.length; ++j) {
                XsdQNameType soapHeaderQName = soapHeaderQNames[j];
                headers[j] = soapHeaderQName.getQNameValue();
            }
            list.add(new HandlerInfo(handlerClass, config, headers));
        }
        return list;
    }

    static {
        rpcHolderClasses.put(BigDecimal.class, BigDecimalHolder.class);
        rpcHolderClasses.put(BigInteger.class, BigIntegerHolder.class);
        rpcHolderClasses.put(Boolean.TYPE, BooleanHolder.class);
        rpcHolderClasses.put(Boolean.class, BooleanWrapperHolder.class);
        rpcHolderClasses.put(byte[].class, ByteArrayHolder.class);
        rpcHolderClasses.put(Byte.TYPE, ByteHolder.class);
        rpcHolderClasses.put(Byte.class, ByteWrapperHolder.class);
        rpcHolderClasses.put(Calendar.class, CalendarHolder.class);
        rpcHolderClasses.put(Double.TYPE, DoubleHolder.class);
        rpcHolderClasses.put(Double.class, DoubleWrapperHolder.class);
        rpcHolderClasses.put(Float.TYPE, FloatHolder.class);
        rpcHolderClasses.put(Float.class, FloatWrapperHolder.class);
        rpcHolderClasses.put(Integer.TYPE, IntHolder.class);
        rpcHolderClasses.put(Integer.class, IntegerWrapperHolder.class);
        rpcHolderClasses.put(Long.TYPE, LongHolder.class);
        rpcHolderClasses.put(Long.class, LongWrapperHolder.class);
        rpcHolderClasses.put(Object.class, ObjectHolder.class);
        rpcHolderClasses.put(QName.class, QNameHolder.class);
        rpcHolderClasses.put(Short.TYPE, ShortHolder.class);
        rpcHolderClasses.put(Short.class, ShortWrapperHolder.class);
        rpcHolderClasses.put(String.class, StringHolder.class);
    }
}

