/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.web.extender;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.geronimo.osgi.web.WebApplicationListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebContainerEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebContainerEventDispatcher.class);
    private ServiceTracker tracker;
    private Bundle extenderBundle;
    private ServiceTracker listenerTracker;
    private final Set<WebApplicationListener> listeners = new CopyOnWriteArraySet<WebApplicationListener>();

    public WebContainerEventDispatcher(final BundleContext bundleContext) {
        this.extenderBundle = bundleContext.getBundle();
        if (this.isEventAdminPresent()) {
            this.tracker = new ServiceTracker(bundleContext, EventAdmin.class.getName(), null);
            this.tracker.open();
        }
        this.listenerTracker = new ServiceTracker(bundleContext, WebApplicationListener.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                WebApplicationListener listener = (WebApplicationListener)bundleContext.getService(reference);
                WebContainerEventDispatcher.this.listeners.add(listener);
                return listener;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                WebContainerEventDispatcher.this.listeners.remove(service);
                bundleContext.ungetService(reference);
            }
        });
        this.listenerTracker.open();
    }

    private boolean isEventAdminPresent() {
        try {
            this.getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            return true;
        }
        catch (Throwable t) {
            LOGGER.debug("EventAdmin package is not available, just don't use it");
            return false;
        }
    }

    public void deploying(Bundle bundle, String contextPath) {
        Dictionary<String, Object> properties = this.createDefaultProperties(bundle, contextPath);
        for (WebApplicationListener listener : this.listeners) {
            try {
                listener.deploying(bundle, contextPath, properties);
            }
            catch (Exception e) {
                LOGGER.warn("Error notifying listener: " + listener, (Throwable)e);
                break;
            }
        }
        this.dispatch("org/osgi/service/web/DEPLOYING", properties);
    }

    public void deployed(Bundle bundle, String contextPath) {
        Dictionary<String, Object> properties = this.createDefaultProperties(bundle, contextPath);
        for (WebApplicationListener listener : this.listeners) {
            try {
                listener.deployed(bundle, contextPath, properties);
            }
            catch (Exception e) {
                LOGGER.warn("Error notifying listener: " + listener, (Throwable)e);
                break;
            }
        }
        this.dispatch("org/osgi/service/web/DEPLOYED", properties);
    }

    public void undeploying(Bundle bundle, String contextPath) {
        Dictionary<String, Object> properties = this.createDefaultProperties(bundle, contextPath);
        for (WebApplicationListener listener : this.listeners) {
            try {
                listener.undeploying(bundle, contextPath, properties);
            }
            catch (Exception e) {
                LOGGER.warn("Error notifying listener: " + listener, (Throwable)e);
                break;
            }
        }
        this.dispatch("org/osgi/service/web/UNDEPLOYING", properties);
    }

    public void undeployed(Bundle bundle, String contextPath) {
        Dictionary<String, Object> properties = this.createDefaultProperties(bundle, contextPath);
        for (WebApplicationListener listener : this.listeners) {
            try {
                listener.undeployed(bundle, contextPath, properties);
            }
            catch (Exception e) {
                LOGGER.warn("Error notifying listener: " + listener, (Throwable)e);
                break;
            }
        }
        this.dispatch("org/osgi/service/web/UNDEPLOYED", properties);
    }

    public void failed(Bundle bundle, String contextPath, Throwable cause) {
        Dictionary<String, Object> properties = this.createDefaultProperties(bundle, contextPath);
        if (cause != null) {
            properties.put("exception", cause);
        }
        for (WebApplicationListener listener : this.listeners) {
            try {
                listener.failed(bundle, contextPath, properties);
            }
            catch (Exception e) {
                LOGGER.warn("Error notifying listener: " + listener, (Throwable)e);
                break;
            }
        }
        this.dispatch("org/osgi/service/web/FAILED", properties);
    }

    public void collision(Bundle bundle, String contextPath, Collection<Long> bundleId) {
        Dictionary<String, Object> properties = this.createDefaultProperties(bundle, contextPath);
        properties.put("collision", contextPath);
        properties.put("collision.bundles", bundleId);
        for (WebApplicationListener listener : this.listeners) {
            try {
                listener.failed(bundle, contextPath, properties);
            }
            catch (Exception e) {
                LOGGER.warn("Error notifying listener: " + listener, (Throwable)e);
                break;
            }
        }
        this.dispatch("org/osgi/service/web/FAILED", properties);
    }

    private void dispatch(String topic, Dictionary<String, Object> props) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin == null) {
            return;
        }
        eventAdmin.postEvent(new Event(topic, props));
    }

    private Dictionary<String, Object> createDefaultProperties(Bundle bundle, String contextPath) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("bundle.symbolicName", bundle.getSymbolicName());
        ((Dictionary)props).put("bundle.id", bundle.getBundleId());
        ((Dictionary)props).put("bundle", bundle);
        ((Dictionary)props).put("bundle.version", this.getBundleVersion(bundle));
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        ((Dictionary)props).put("context.path", contextPath);
        ((Dictionary)props).put("extender.bundle", this.extenderBundle);
        ((Dictionary)props).put("extender.bundle.id", this.extenderBundle.getBundleId());
        ((Dictionary)props).put("extender.bundle.symbolicName", this.extenderBundle.getSymbolicName());
        ((Dictionary)props).put("extender.bundle.version", this.getBundleVersion(this.extenderBundle));
        return props;
    }

    private EventAdmin getEventAdmin() {
        return this.tracker != null ? (EventAdmin)this.tracker.getService() : null;
    }

    public void destroy() {
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.listenerTracker.close();
    }

    private Version getBundleVersion(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String version = (String)headers.get("Bundle-Version");
        return version != null ? Version.parseVersion((String)version) : Version.emptyVersion;
    }
}

