/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.ServiceRef;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class ServiceRefMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String SERVICE_REF_NAME_PREFIX = "service-ref.service-ref-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (ServiceRef srcServiceRef : webFragment.getServiceRef()) {
            String serviceRefName = srcServiceRef.getServiceRefName();
            String serviceRefKey = ServiceRefMergeHandler.createServiceRefKey(serviceRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(serviceRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("service-ref", serviceRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || ServiceRefMergeHandler.isServiceRefInjectTargetsConfiguredInInitialWebXML(serviceRefName, mergeContext)) continue;
                ServiceRef serviceRef = (ServiceRef)mergeItem.getValue();
                for (InjectionTarget injectTarget : srcServiceRef.getInjectionTarget()) {
                    String serviceRefInjectTargetKey = ServiceRefMergeHandler.createServiceRefInjectTargetKey(serviceRefName, injectTarget.getInjectionTargetClass(), injectTarget.getInjectionTargetName());
                    if (mergeContext.containsAttribute(serviceRefInjectTargetKey)) continue;
                    serviceRef.getInjectionTarget().add(injectTarget);
                    mergeContext.setAttribute(serviceRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            webApp.getServiceRef().add(srcServiceRef);
            mergeContext.setAttribute(serviceRefKey, new MergeItem(srcServiceRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTarget injectionTarget : srcServiceRef.getInjectionTarget()) {
                mergeContext.setAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetKey(serviceRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (ServiceRef serviceRef : webApp.getServiceRef()) {
            String serviceRefName = serviceRef.getServiceRefName();
            mergeContext.setAttribute(ServiceRefMergeHandler.createServiceRefKey(serviceRefName), new MergeItem(serviceRef, null, ElementSource.WEB_XML));
            if (!serviceRef.getInjectionTarget().isEmpty()) {
                mergeContext.setAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetConfiguredInWebXMLKey(serviceRefName), Boolean.TRUE);
            }
            for (InjectionTarget injectionTarget : serviceRef.getInjectionTarget()) {
                mergeContext.setAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetKey(serviceRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    public static String createServiceRefInjectTargetConfiguredInWebXMLKey(String serviceRefName) {
        return SERVICE_REF_NAME_PREFIX + serviceRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createServiceRefInjectTargetKey(String serviceRefName, String injectTargetClassName, String injectTargetName) {
        return SERVICE_REF_NAME_PREFIX + serviceRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createServiceRefKey(String serviceRefName) {
        return SERVICE_REF_NAME_PREFIX + serviceRefName;
    }

    public static boolean isServiceRefInjectTargetConfigured(String serviceRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetKey(serviceRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isServiceRefInjectTargetsConfiguredInInitialWebXML(String serviceRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServiceRefMergeHandler.createServiceRefInjectTargetConfiguredInWebXMLKey(serviceRefName));
    }
}

