/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.WebApp;

public class ServletLoadOnStartupMergeHandler
implements SubMergeHandler<Servlet, Servlet> {
    @Override
    public void add(Servlet servlet, MergeContext mergeContext) throws DeploymentException {
        if (servlet.getLoadOnStartup() != null) {
            mergeContext.setAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupKey(servlet.getServletName()), new MergeItem(servlet.getLoadOnStartup(), mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
        }
    }

    @Override
    public void merge(Servlet srcServlet, Servlet targetServlet, MergeContext mergeContext) throws DeploymentException {
        String servletName = srcServlet.getServletName();
        if (ServletLoadOnStartupMergeHandler.isServletLoadOnStartupConfiguredInWebXML(servletName, mergeContext)) {
            return;
        }
        if (srcServlet.getLoadOnStartup() != null) {
            Integer srcLoadOnStartupValue = srcServlet.getLoadOnStartup();
            MergeItem existedLoadOnStartup = (MergeItem)mergeContext.getAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupKey(servletName));
            if (existedLoadOnStartup == null) {
                targetServlet.setLoadOnStartup(srcLoadOnStartupValue);
                mergeContext.setAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupKey(servletName), new MergeItem(srcLoadOnStartupValue, mergeContext.getCurrentJarUrl(), ElementSource.WEB_XML));
            } else if (!existedLoadOnStartup.getValue().equals(srcLoadOnStartupValue)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateValueMessage("servlet " + servletName, "load-on-startup", existedLoadOnStartup.getValue().toString(), existedLoadOnStartup.getBelongedURL(), srcLoadOnStartupValue.toString(), mergeContext.getCurrentJarUrl()));
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (Servlet servlet : webApp.getServlet()) {
            if (servlet.getLoadOnStartup() == null) continue;
            context.setAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupConfiguredInWebXMLKey(servlet.getServletName()), Boolean.TRUE);
        }
    }

    public static String createServletLoadOnStartupConfiguredInWebXMLKey(String servletName) {
        return "servlet.servlet-name." + servletName + ".load-on-startup.configured_in_web_xml";
    }

    public static String createServletLoadOnStartupKey(String servletName) {
        return "servlet.servlet-name." + servletName + ".load-on-startup";
    }

    public static boolean isServletLoadOnStartupConfiguredInWebXML(String servletName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupConfiguredInWebXMLKey(servletName));
    }
}

