/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.openejb.jee.SecurityRole;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class SecurityRoleMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (SecurityRole securityRole : webFragment.getSecurityRole()) {
            String securityRoleKey = SecurityRoleMergeHandler.createSecurityRoleKey(securityRole.getRoleName());
            if (mergeContext.containsAttribute(securityRoleKey)) continue;
            mergeContext.setAttribute(securityRoleKey, Boolean.TRUE);
            webApp.getSecurityRole().add(securityRole);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (SecurityRole securityRole : webApp.getSecurityRole()) {
            context.setAttribute(SecurityRoleMergeHandler.createSecurityRoleKey(securityRole.getRoleName()), Boolean.TRUE);
        }
    }

    public static String createSecurityRoleKey(String roleName) {
        return "security-role.role-name." + roleName;
    }
}

