/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class MessageDestinationRefMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String MESSAGE_DESTINATION_REF_NAME_PREFIX = "message-destination-ref.message-destination-ref-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (MessageDestinationRef srcMessageDestinationRef : webFragment.getMessageDestinationRef()) {
            String messageDestinationRefName = srcMessageDestinationRef.getMessageDestinationRefName();
            String messageDestinationRefKey = MessageDestinationRefMergeHandler.createMessageDestinationRefKey(messageDestinationRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(messageDestinationRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("message-destination-ref", messageDestinationRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || MessageDestinationRefMergeHandler.isMessageDestinationRefInjectTargetsConfiguredInInitialWebXML(messageDestinationRefName, mergeContext)) continue;
                MessageDestinationRef messageDestinationRef = (MessageDestinationRef)mergeItem.getValue();
                for (InjectionTarget injectTarget : srcMessageDestinationRef.getInjectionTarget()) {
                    String messageDestinationRefInjectTargetKey = MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetKey(messageDestinationRefName, injectTarget.getInjectionTargetClass(), injectTarget.getInjectionTargetName());
                    if (mergeContext.containsAttribute(messageDestinationRefInjectTargetKey)) continue;
                    messageDestinationRef.getInjectionTarget().add(injectTarget);
                    mergeContext.setAttribute(messageDestinationRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            webApp.getMessageDestinationRef().add(srcMessageDestinationRef);
            mergeContext.setAttribute(messageDestinationRefKey, new MergeItem(srcMessageDestinationRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTarget injectionTarget : srcMessageDestinationRef.getInjectionTarget()) {
                mergeContext.setAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetKey(messageDestinationRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (MessageDestinationRef messageDestinationRef : webApp.getMessageDestinationRef()) {
            String messageDestinationRefName = messageDestinationRef.getMessageDestinationRefName();
            mergeContext.setAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefKey(messageDestinationRefName), new MergeItem(messageDestinationRef, null, ElementSource.WEB_XML));
            if (!messageDestinationRef.getInjectionTarget().isEmpty()) {
                mergeContext.setAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetConfiguredInWebXMLKey(messageDestinationRefName), Boolean.TRUE);
            }
            for (InjectionTarget injectionTarget : messageDestinationRef.getInjectionTarget()) {
                mergeContext.setAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetKey(messageDestinationRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    public static String createMessageDestinationRefInjectTargetConfiguredInWebXMLKey(String messageDestinationRefName) {
        return MESSAGE_DESTINATION_REF_NAME_PREFIX + messageDestinationRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createMessageDestinationRefInjectTargetKey(String messageDestinationRefName, String injectTargetClassName, String injectTargetName) {
        return MESSAGE_DESTINATION_REF_NAME_PREFIX + messageDestinationRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createMessageDestinationRefKey(String messageDestinationRefName) {
        return MESSAGE_DESTINATION_REF_NAME_PREFIX + messageDestinationRefName;
    }

    public static boolean isMessageDestinationRefInjectTargetConfigured(String messageDestinationRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetKey(messageDestinationRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isMessageDestinationRefInjectTargetsConfiguredInInitialWebXML(String messageDestinationRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetConfiguredInWebXMLKey(messageDestinationRefName));
    }
}

