/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class ContextParamMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String QUALIFIED_CONTEXT_PARAM_NAME_PREFIX = "context-param.param-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        String jarUrl = mergeContext.getCurrentJarUrl();
        for (ParamValue paramValue : webFragment.getContextParam()) {
            String qualifiedContextParamName = QUALIFIED_CONTEXT_PARAM_NAME_PREFIX + paramValue.getParamName();
            if (mergeContext.containsAttribute(qualifiedContextParamName)) continue;
            MergeItem existedContextParamValue = (MergeItem)mergeContext.getAttribute(qualifiedContextParamName);
            if (existedContextParamValue == null) {
                webApp.getContextParam().add(paramValue);
                mergeContext.setAttribute(qualifiedContextParamName, new MergeItem(paramValue.getParamValue(), jarUrl, ElementSource.WEB_FRAGMENT));
                continue;
            }
            if (existedContextParamValue.getValue().equals(paramValue.getParamValue())) continue;
            throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("context-param", "param-name", paramValue.getParamName(), "param-value", existedContextParamValue.getValue().toString(), existedContextParamValue.getBelongedURL(), paramValue.getParamValue(), jarUrl));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (ParamValue paramValue : webApp.getContextParam()) {
            context.setAttribute(QUALIFIED_CONTEXT_PARAM_NAME_PREFIX + paramValue.getParamName(), paramValue.getParamName());
        }
    }
}

