/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.utils;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.FilterMapping;
import org.apache.openejb.jee.JspConfig;
import org.apache.openejb.jee.JspPropertyGroup;
import org.apache.openejb.jee.SecurityConstraint;
import org.apache.openejb.jee.ServletMapping;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebResourceCollection;

public class WebDeploymentValidationUtils {
    private static final Pattern HTTP_METHOD_PATTERN = Pattern.compile("[!-~&&[^\\(\\)\\<\\>@,;:\\\\\"/\\[\\]\\?=\\{\\}]]*");

    public static boolean isValidUrlPattern(String urlPattern) {
        return urlPattern.indexOf(13) < 0 && urlPattern.indexOf(10) < 0;
    }

    public static boolean isValidHTTPMethod(String httpMethod) {
        return HTTP_METHOD_PATTERN.matcher(httpMethod).matches();
    }

    public static void validateWebApp(WebApp webApp) throws DeploymentException {
        WebDeploymentValidationUtils.checkURLPattern(webApp);
        WebDeploymentValidationUtils.checkMultiplicities(webApp);
    }

    private static void checkURLPattern(WebApp webApp) throws DeploymentException {
        List filterMappings = webApp.getFilterMapping();
        for (FilterMapping filterMapping : filterMappings) {
            for (String urlPattern : filterMapping.getUrlPattern()) {
                if (WebDeploymentValidationUtils.isValidUrlPattern(urlPattern.trim())) continue;
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("filter-mapping", filterMapping.getFilterName(), urlPattern, "web.xml"));
            }
        }
        List servletMappings = webApp.getServletMapping();
        for (ServletMapping servletMapping : servletMappings) {
            for (String urlPattern : servletMapping.getUrlPattern()) {
                if (WebDeploymentValidationUtils.isValidUrlPattern(urlPattern.trim())) continue;
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("servlet-mapping", servletMapping.getServletName(), urlPattern, "web.xml"));
            }
        }
        List jspConfigs = webApp.getJspConfig();
        for (JspConfig jspConfig : jspConfigs) {
            for (JspPropertyGroup propertyGroup : jspConfig.getJspPropertyGroup()) {
                for (String urlPattern : propertyGroup.getUrlPattern()) {
                    if (WebDeploymentValidationUtils.isValidUrlPattern(urlPattern.trim())) continue;
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("jsp-config", propertyGroup.getDisplayName(), urlPattern, "web.xml"));
                }
            }
        }
        List constraints = webApp.getSecurityConstraint();
        for (SecurityConstraint constraint : constraints) {
            for (WebResourceCollection collection : constraint.getWebResourceCollection()) {
                for (String pattern : collection.getUrlPattern()) {
                    if (WebDeploymentValidationUtils.isValidUrlPattern(pattern.trim())) continue;
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("security-constraint", collection.getWebResourceName(), pattern, "web.xml"));
                }
            }
        }
    }

    private static void checkMultiplicities(WebApp webApp) throws DeploymentException {
        if (webApp.getSessionConfig().size() > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("session-config"));
        }
        if (webApp.getJspConfig().size() > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("jsp-config"));
        }
        if (webApp.getLoginConfig().size() > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("login-config"));
        }
    }
}

