/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterInitParamMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.openejb.jee.Filter;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class FilterMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    private List<SubMergeHandler<Filter, Filter>> subMergeHandlers = new ArrayList<SubMergeHandler<Filter, Filter>>(1);

    public FilterMergeHandler() {
        this.subMergeHandlers.add(new FilterInitParamMergeHandler());
    }

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (Filter srcFilter : webFragment.getFilter()) {
            String filterName = srcFilter.getFilterName();
            Filter targetFilter = (Filter)mergeContext.getAttribute(FilterMergeHandler.createFilterKey(filterName));
            if (targetFilter == null) {
                webApp.getFilter().add(srcFilter);
                mergeContext.setAttribute(FilterMergeHandler.createFilterKey(filterName), srcFilter);
                for (SubMergeHandler<Filter, Filter> subMergeHandler : this.subMergeHandlers) {
                    subMergeHandler.add(srcFilter, mergeContext);
                }
                continue;
            }
            for (SubMergeHandler<Filter, Filter> subMergeHandler : this.subMergeHandlers) {
                subMergeHandler.merge(srcFilter, targetFilter, mergeContext);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (SubMergeHandler<Filter, Filter> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.postProcessWebXmlElement(webApp, mergeContext);
        }
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (Filter filter : webApp.getFilter()) {
            mergeContext.setAttribute(FilterMergeHandler.createFilterKey(filter.getFilterName()), filter);
        }
        for (SubMergeHandler subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.preProcessWebXmlElement(webApp, mergeContext);
        }
    }

    public static String createFilterKey(String filterName) {
        return "filter.filter-name." + filterName;
    }

    public static boolean isFilterConfigured(String filterName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(FilterMergeHandler.createFilterKey(filterName));
    }

    public static Filter getFilter(String filterName, MergeContext mergeContext) {
        return (Filter)mergeContext.getAttribute(FilterMergeHandler.createFilterKey(filterName));
    }

    public static void addFilter(Filter filter, MergeContext mergeContext) {
        mergeContext.setAttribute(FilterMergeHandler.createFilterKey(filter.getFilterName()), filter);
    }
}

