/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class EjbRefMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String EJB_REF_NAME_PREFIX = "ejb-ref.ejb-ref-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (EjbRef srcEjbRef : webFragment.getEjbRef()) {
            String ejbRefName = srcEjbRef.getEjbRefName();
            String ejbRefKey = EjbRefMergeHandler.createEjbRefKey(ejbRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(ejbRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("ejb-ref", ejbRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || EjbRefMergeHandler.isEjbRefInjectTargetsConfiguredInInitialWebXML(ejbRefName, mergeContext)) continue;
                EjbRef ejbRef = (EjbRef)mergeItem.getValue();
                for (InjectionTarget injectTarget : srcEjbRef.getInjectionTarget()) {
                    String ejbRefInjectTargetKey = EjbRefMergeHandler.createEjbRefInjectTargetKey(ejbRefName, injectTarget.getInjectionTargetClass(), injectTarget.getInjectionTargetName());
                    if (mergeContext.containsAttribute(ejbRefInjectTargetKey)) continue;
                    ejbRef.getInjectionTarget().add(injectTarget);
                    mergeContext.setAttribute(ejbRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            webApp.getEjbRef().add(srcEjbRef);
            mergeContext.setAttribute(ejbRefKey, new MergeItem(srcEjbRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTarget injectionTarget : srcEjbRef.getInjectionTarget()) {
                mergeContext.setAttribute(EjbRefMergeHandler.createEjbRefInjectTargetKey(ejbRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (EjbRef ejbRef : webApp.getEjbRef()) {
            String ejbRefName = ejbRef.getEjbRefName();
            mergeContext.setAttribute(EjbRefMergeHandler.createEjbRefKey(ejbRefName), new MergeItem(ejbRef, null, ElementSource.WEB_XML));
            if (ejbRef.getInjectionTarget().size() > 0) {
                mergeContext.setAttribute(EjbRefMergeHandler.createEjbRefInjectTargetConfiguredInWebXMLKey(ejbRefName), Boolean.TRUE);
            }
            for (InjectionTarget injectionTarget : ejbRef.getInjectionTarget()) {
                mergeContext.setAttribute(EjbRefMergeHandler.createEjbRefInjectTargetKey(ejbRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    public static String createEjbRefInjectTargetConfiguredInWebXMLKey(String ejbRefName) {
        return EJB_REF_NAME_PREFIX + ejbRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createEjbRefInjectTargetKey(String ejbRefName, String injectTargetClassName, String injectTargetName) {
        return EJB_REF_NAME_PREFIX + ejbRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createEjbRefKey(String ejbRefName) {
        return EJB_REF_NAME_PREFIX + ejbRefName;
    }

    public static boolean isEjbRefInjectTargetConfigured(String ejbRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EjbRefMergeHandler.createEjbRefInjectTargetKey(ejbRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isEjbRefInjectTargetsConfiguredInInitialWebXML(String ejbRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EjbRefMergeHandler.createEjbRefInjectTargetConfiguredInWebXMLKey(ejbRefName));
    }
}

