/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class EjbLocalRefMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    public static final String EJB_LOCAL_REF_NAME_PREFIX = "ejb-local-ref.ejb-ref-name.";

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (EjbLocalRef srcEjbLocalRef : webFragment.getEjbLocalRef()) {
            String ejbLocalRefName = srcEjbLocalRef.getEjbRefName();
            String ejbLocalRefKey = EjbLocalRefMergeHandler.createEjbLocalRefKey(ejbLocalRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(ejbLocalRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("ejb-local-ref", ejbLocalRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || EjbLocalRefMergeHandler.isEjbLocalRefInjectTargetsConfiguredInInitialWebXML(ejbLocalRefName, mergeContext)) continue;
                EjbLocalRef ejbLocalRef = (EjbLocalRef)mergeItem.getValue();
                for (InjectionTarget injectTarget : srcEjbLocalRef.getInjectionTarget()) {
                    String ejbLocalRefInjectTargetKey = EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetKey(ejbLocalRefName, injectTarget.getInjectionTargetClass(), injectTarget.getInjectionTargetName());
                    if (mergeContext.containsAttribute(ejbLocalRefInjectTargetKey)) continue;
                    ejbLocalRef.getInjectionTarget().add(injectTarget);
                    mergeContext.setAttribute(ejbLocalRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            webApp.getEjbLocalRef().add(srcEjbLocalRef);
            mergeContext.setAttribute(ejbLocalRefKey, new MergeItem(srcEjbLocalRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTarget injectionTarget : srcEjbLocalRef.getInjectionTarget()) {
                mergeContext.setAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetKey(ejbLocalRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (EjbLocalRef ejbLocalRef : webApp.getEjbLocalRef()) {
            String ejbLocalRefName = ejbLocalRef.getEjbRefName();
            mergeContext.setAttribute(EjbLocalRefMergeHandler.createEjbLocalRefKey(ejbLocalRefName), new MergeItem(ejbLocalRef, null, ElementSource.WEB_XML));
            if (ejbLocalRef.getInjectionTarget().size() > 0) {
                mergeContext.setAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetConfiguredInWebXMLKey(ejbLocalRefName), Boolean.TRUE);
            }
            for (InjectionTarget injectionTarget : ejbLocalRef.getInjectionTarget()) {
                mergeContext.setAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetKey(ejbLocalRefName, injectionTarget.getInjectionTargetClass(), injectionTarget.getInjectionTargetName()), Boolean.TRUE);
            }
        }
    }

    public static String createEjbLocalRefInjectTargetConfiguredInWebXMLKey(String ejbLocalRefName) {
        return EJB_LOCAL_REF_NAME_PREFIX + ejbLocalRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createEjbLocalRefInjectTargetKey(String ejbLocalRefName, String injectTargetClassName, String injectTargetName) {
        return EJB_LOCAL_REF_NAME_PREFIX + ejbLocalRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createEjbLocalRefKey(String ejbLocalRefName) {
        return EJB_LOCAL_REF_NAME_PREFIX + ejbLocalRefName;
    }

    public static boolean isEjbLocalRefInjectTargetConfigured(String ejbLocalRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetKey(ejbLocalRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isEjbLocalRefInjectTargetsConfiguredInInitialWebXML(String ejbLocalRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EjbLocalRefMergeHandler.createEjbLocalRefInjectTargetConfiguredInWebXMLKey(ejbLocalRefName));
    }
}

