/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.annotation;

import java.util.Arrays;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.annotation.AnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ListenerMergeHandler;
import org.apache.openejb.jee.Listener;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.WebApp;

public class WebListenerAnnotationMergeHandler
implements AnnotationMergeHandler {
    public static final Class<?>[] SUPPORTED_WEBLISTENER_INTERFACES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class, AsyncListener.class};

    @Override
    public void merge(Class<?>[] classes, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (Class<?> cls : classes) {
            Class<?> implementedWebListenerInterface = null;
            for (Class<?> supportedWebListenerInterface : SUPPORTED_WEBLISTENER_INTERFACES) {
                if (!supportedWebListenerInterface.isAssignableFrom(cls)) continue;
                implementedWebListenerInterface = supportedWebListenerInterface;
                break;
            }
            if (implementedWebListenerInterface == null) {
                throw new DeploymentException("One of supported web listener interface " + Arrays.toString(SUPPORTED_WEBLISTENER_INTERFACES) + " should  be implemented by class " + cls.getName() + " while WebListener annotation is used");
            }
            WebListener webListener = cls.getAnnotation(WebListener.class);
            if (ListenerMergeHandler.isListenerConfigured(cls.getName(), mergeContext)) {
                return;
            }
            Listener newListener = new Listener();
            if (!webListener.value().isEmpty()) {
                newListener.addDescription(new Text(null, webListener.value()));
            }
            newListener.setListenerClass(cls.getName());
            webApp.getListener().add(newListener);
            ListenerMergeHandler.addListener(newListener, mergeContext);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
    }
}

