/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment;

import java.util.List;
import java.util.Map;
import org.apache.geronimo.web.info.FilterInfo;
import org.apache.geronimo.web.info.SecurityConstraintInfo;
import org.apache.geronimo.web.info.ServletInfo;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.geronimo.web25.deployment.DefaultWebAppInfoFactory;

public class StandardWebAppInfoFactory
extends DefaultWebAppInfoFactory {
    private final ServletInfo jspServletInfo;
    private final WebAppInfo defaultWebAppInfo;

    public StandardWebAppInfoFactory(WebAppInfo defaultWebAppInfo, ServletInfo jspServletInfo) {
        this.defaultWebAppInfo = defaultWebAppInfo;
        this.jspServletInfo = jspServletInfo;
    }

    @Override
    public void complete(WebAppInfo webAppInfo) {
        for (ServletInfo servletInfo : this.defaultWebAppInfo.servlets) {
            if (!this.noServlet(servletInfo.servletName, webAppInfo.servlets)) continue;
            webAppInfo.servlets.add(this.copy(servletInfo));
        }
        for (FilterInfo filterInfo : this.defaultWebAppInfo.filters) {
            if (!this.noFilter(filterInfo.filterName, webAppInfo.filters)) continue;
            webAppInfo.filters.add(this.copy(filterInfo));
        }
        webAppInfo.listeners.addAll(this.defaultWebAppInfo.listeners);
        for (Map.Entry entry : this.defaultWebAppInfo.contextParams.entrySet()) {
            if (webAppInfo.contextParams.containsKey(entry.getKey())) continue;
            webAppInfo.contextParams.put(entry.getKey(), entry.getValue());
        }
        for (SecurityConstraintInfo securityConstraintInfo : this.defaultWebAppInfo.securityConstraints) {
            webAppInfo.securityConstraints.add(this.copy(securityConstraintInfo));
        }
        webAppInfo.securityRoles.addAll(this.defaultWebAppInfo.securityRoles);
        if (webAppInfo.welcomeFiles.isEmpty()) {
            webAppInfo.welcomeFiles.addAll(this.defaultWebAppInfo.welcomeFiles);
        }
        webAppInfo.errorPages.addAll(this.defaultWebAppInfo.errorPages);
        for (Map.Entry entry : this.defaultWebAppInfo.mimeMappings.entrySet()) {
            if (webAppInfo.mimeMappings.containsKey(entry.getKey())) continue;
            webAppInfo.mimeMappings.put(entry.getKey(), entry.getValue());
        }
    }

    private boolean noServlet(String servletName, List<ServletInfo> servlets) {
        for (ServletInfo servletInfo : servlets) {
            if (!servletName.equals(servletInfo.servletName)) continue;
            return false;
        }
        return true;
    }

    private boolean noFilter(String filterName, List<FilterInfo> filters) {
        for (FilterInfo filterInfo : filters) {
            if (!filterName.equals(filterInfo.filterName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ServletInfo newJspInfo(String jspFile) {
        ServletInfo servletInfo = this.copy(this.jspServletInfo);
        servletInfo.initParams.put("jspFile", jspFile);
        return servletInfo;
    }
}

