/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.utils;

import java.util.regex.Pattern;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.FilterMappingType;
import org.apache.geronimo.xbeans.javaee6.SecurityConstraintType;
import org.apache.geronimo.xbeans.javaee6.ServletMappingType;
import org.apache.geronimo.xbeans.javaee6.UrlPatternType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebResourceCollectionType;

public class WebDeploymentValidationUtils {
    private static final Pattern HTTP_METHOD_PATTERN = Pattern.compile("[!-~&&[^\\(\\)\\<\\>@,;:\\\\\"/\\[\\]\\?=\\{\\}]]*");

    public static boolean isValidUrlPattern(String urlPattern) {
        return urlPattern.indexOf(13) < 0 && urlPattern.indexOf(10) < 0;
    }

    public static boolean isValidHTTPMethod(String httpMethod) {
        return HTTP_METHOD_PATTERN.matcher(httpMethod).matches();
    }

    public static void validateWebApp(WebAppType webApp) throws DeploymentException {
        WebDeploymentValidationUtils.checkURLPattern(webApp);
        WebDeploymentValidationUtils.checkMultiplicities(webApp);
    }

    private static void checkURLPattern(WebAppType webApp) throws DeploymentException {
        SecurityConstraintType[] constraints;
        ServletMappingType[] servletMappings;
        FilterMappingType[] filterMappings;
        for (FilterMappingType filterMapping : filterMappings = webApp.getFilterMappingArray()) {
            for (UrlPatternType urlPattern : filterMapping.getUrlPatternArray()) {
                if (WebDeploymentValidationUtils.isValidUrlPattern(urlPattern.getStringValue().trim())) continue;
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("filter-mapping", filterMapping.getFilterName().getStringValue(), urlPattern.getStringValue(), "web.xml"));
            }
        }
        for (ServletMappingType servletMapping : servletMappings = webApp.getServletMappingArray()) {
            for (UrlPatternType urlPattern : servletMapping.getUrlPatternArray()) {
                if (WebDeploymentValidationUtils.isValidUrlPattern(urlPattern.getStringValue().trim())) continue;
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("servlet-mapping", servletMapping.getServletName().getStringValue(), urlPattern.getStringValue(), "web.xml"));
            }
        }
        for (SecurityConstraintType constraint : constraints = webApp.getSecurityConstraintArray()) {
            WebResourceCollectionType[] collections;
            for (WebResourceCollectionType collection : collections = constraint.getWebResourceCollectionArray()) {
                UrlPatternType[] patterns;
                for (UrlPatternType pattern : patterns = collection.getUrlPatternArray()) {
                    if (WebDeploymentValidationUtils.isValidUrlPattern(pattern.getStringValue().trim())) continue;
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("security-constraint", collection.getWebResourceName().getStringValue(), pattern.getStringValue(), "web.xml"));
                }
            }
        }
    }

    private static void checkMultiplicities(WebAppType webApp) throws DeploymentException {
        if (webApp.getSessionConfigArray().length > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("session-config"));
        }
        if (webApp.getJspConfigArray().length > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("jsp-config"));
        }
        if (webApp.getLoginConfigArray().length > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("login-config"));
        }
    }
}

