/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.geronimo.xbeans.javaee6.WelcomeFileListType;

public class WelcomeFileListMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        WelcomeFileListType targetWelcomeFileList = null;
        for (WelcomeFileListType welcomeFileList : webFragment.getWelcomeFileListArray()) {
            for (String welcomeFile : welcomeFileList.getWelcomeFileArray()) {
                String welcomeFileKey = WelcomeFileListMergeHandler.createWelcomeFileKey(welcomeFile);
                if (mergeContext.containsAttribute(welcomeFileKey)) continue;
                if (targetWelcomeFileList == null) {
                    targetWelcomeFileList = webApp.getWelcomeFileListArray().length > 0 ? webApp.getWelcomeFileListArray(0) : webApp.addNewWelcomeFileList();
                }
                targetWelcomeFileList.addNewWelcomeFile().setStringValue(welcomeFile);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType parentElement, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        WelcomeFileListType[] welcomeFileLists = webApp.getWelcomeFileListArray();
        if (welcomeFileLists.length == 0) {
            return;
        }
        if (welcomeFileLists.length > 1) {
            int i;
            WelcomeFileListType targetWelcomeFileList = welcomeFileLists[0];
            for (i = 1; i < welcomeFileLists.length; ++i) {
                WelcomeFileListType welcomeFileList = welcomeFileLists[i];
                for (String welcomeFile : welcomeFileList.getWelcomeFileArray()) {
                    targetWelcomeFileList.addNewWelcomeFile().setStringValue(welcomeFile);
                }
            }
            int iLength = welcomeFileLists.length;
            for (i = 1; i < iLength; ++i) {
                webApp.removeWelcomeFileList(1);
            }
        }
        for (String welcomeFile : welcomeFileLists[0].getWelcomeFileArray()) {
            context.setAttribute(WelcomeFileListMergeHandler.createWelcomeFileKey(welcomeFile), Boolean.TRUE);
        }
    }

    public static String createWelcomeFileKey(String welcomeFile) {
        return "welcome-file-list.welcome-file." + welcomeFile;
    }

    public static boolean isWelcomeFileConfigured(String welcomeFile, MergeContext mergeContext) {
        return mergeContext.containsAttribute(WelcomeFileListMergeHandler.createWelcomeFileKey(welcomeFile));
    }
}

