/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentValidationUtils;
import org.apache.geronimo.xbeans.javaee6.ServletMappingType;
import org.apache.geronimo.xbeans.javaee6.UrlPatternType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.xmlbeans.XmlObject;

public class ServletMappingUrlPatternMergeHandler
implements SubMergeHandler<ServletMappingType, ServletMappingType> {
    @Override
    public void add(ServletMappingType servletMapping, MergeContext mergeContext) throws DeploymentException {
        String servletName = servletMapping.getServletName().getStringValue();
        for (UrlPatternType urlPattern : servletMapping.getUrlPatternArray()) {
            String urlPatternStr = urlPattern.getStringValue();
            if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPatternStr)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("servlet-mapping", servletName, urlPatternStr, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
            }
            mergeContext.setAttribute(ServletMappingUrlPatternMergeHandler.createServletMappingUrlPatternKey(servletName, urlPattern.getStringValue()), urlPattern);
        }
    }

    @Override
    public void merge(ServletMappingType srcServletMapping, ServletMappingType targetServletMapping, MergeContext mergeContext) throws DeploymentException {
        String servletName = srcServletMapping.getServletName().getStringValue();
        for (UrlPatternType urlPattern : srcServletMapping.getUrlPatternArray()) {
            String urlPatternStr = urlPattern.getStringValue();
            String servletMappingUrlPatternKey = ServletMappingUrlPatternMergeHandler.createServletMappingUrlPatternKey(servletName, urlPatternStr);
            if (mergeContext.containsAttribute(servletMappingUrlPatternKey)) continue;
            UrlPatternType newUrlPattern = (UrlPatternType)targetServletMapping.addNewUrlPattern().set((XmlObject)urlPattern);
            if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPatternStr)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("servlet-mapping", servletName, urlPatternStr, "web-fragment.xml located in " + mergeContext.getCurrentJarUrl()));
            }
            mergeContext.setAttribute(servletMappingUrlPatternKey, newUrlPattern);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (ServletMappingType servletMapping : webApp.getServletMappingArray()) {
            String servletName = servletMapping.getServletName().getStringValue();
            for (UrlPatternType urlPattern : servletMapping.getUrlPatternArray()) {
                String urlPatternStr = urlPattern.getStringValue();
                if (!WebDeploymentValidationUtils.isValidUrlPattern(urlPatternStr)) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createInvalidUrlPatternErrorMessage("servlet-mapping", servletName, urlPatternStr, "web.xml"));
                }
                context.setAttribute(ServletMappingUrlPatternMergeHandler.createServletMappingUrlPatternKey(servletName, urlPatternStr), urlPattern);
            }
        }
    }

    public static String createServletMappingUrlPatternKey(String servletName, String urlPattern) {
        return "servlet-mapping.servlet-name." + servletName + ".url-pattern." + urlPattern;
    }
}

