/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.ParamValueType;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.xmlbeans.XmlObject;

public class ServletInitParamMergeHandler
implements SubMergeHandler<ServletType, ServletType> {
    @Override
    public void add(ServletType servlet, MergeContext mergeContext) throws DeploymentException {
        String servletName = servlet.getServletName().getStringValue();
        for (ParamValueType paramValue : servlet.getInitParamArray()) {
            ServletInitParamMergeHandler.addServletInitParam(servletName, paramValue, ElementSource.WEB_FRAGMENT, mergeContext.getCurrentJarUrl(), mergeContext);
        }
    }

    @Override
    public void merge(ServletType srcServlet, ServletType targetServlet, MergeContext mergeContext) throws DeploymentException {
        String servletName = srcServlet.getServletName().getStringValue();
        block5: for (ParamValueType paramValue : srcServlet.getInitParamArray()) {
            MergeItem existedMergeItem = (MergeItem)mergeContext.getAttribute(ServletInitParamMergeHandler.createServletInitParamKey(servletName, paramValue.getParamName().getStringValue()));
            if (existedMergeItem == null) {
                targetServlet.addNewInitParam().set((XmlObject)paramValue);
                ServletInitParamMergeHandler.addServletInitParam(servletName, paramValue, ElementSource.WEB_FRAGMENT, mergeContext.getCurrentJarUrl(), mergeContext);
                continue;
            }
            ParamValueType existedParamValue = (ParamValueType)existedMergeItem.getValue();
            switch (existedMergeItem.getSourceType()) {
                case WEB_XML: {
                    continue block5;
                }
                case WEB_FRAGMENT: {
                    if (existedParamValue.getParamValue().getStringValue().equals(paramValue.getParamValue().getStringValue()) || existedMergeItem.getBelongedURL().equals(mergeContext.getCurrentJarUrl())) continue block5;
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("servlet " + servletName, "param-name", paramValue.getParamName().getStringValue(), "param-value", existedParamValue.getParamValue().getStringValue(), existedMergeItem.getBelongedURL(), paramValue.getParamValue().getStringValue(), mergeContext.getCurrentJarUrl()));
                }
                case ANNOTATION: {
                    existedParamValue.getParamValue().set((XmlObject)paramValue.getParamValue());
                    existedMergeItem.setBelongedURL(mergeContext.getCurrentJarUrl());
                    existedMergeItem.setSourceType(ElementSource.WEB_FRAGMENT);
                }
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (ServletType servlet : webApp.getServletArray()) {
            String servletName = servlet.getServletName().getStringValue();
            for (ParamValueType paramValue : servlet.getInitParamArray()) {
                ServletInitParamMergeHandler.addServletInitParam(servletName, paramValue, ElementSource.WEB_XML, null, context);
            }
        }
    }

    public static String createServletInitParamKey(String servletName, String paramName) {
        return "servlet." + servletName + ".init-param.param-name." + paramName;
    }

    public static boolean isServletInitParamConfigured(String servletName, String paramName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServletInitParamMergeHandler.createServletInitParamKey(servletName, paramName));
    }

    public static void addServletInitParam(String servletName, ParamValueType paramValue, ElementSource source, String relativeUrl, MergeContext mergeContext) {
        mergeContext.setAttribute(ServletInitParamMergeHandler.createServletInitParamKey(servletName, paramValue.getParamName().getStringValue()), new MergeItem(paramValue, relativeUrl, source));
    }
}

