/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.ResourceRefType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class ResourceRefMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String RESOURCE_REF_NAME_PREFIX = "resource-ref.res-ref-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ResourceRefType srcResourceRef : webFragment.getResourceRefArray()) {
            String resourceRefName = srcResourceRef.getResRefName().getStringValue();
            String resourceRefKey = ResourceRefMergeHandler.createResourceRefKey(resourceRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(resourceRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("resource-ref", resourceRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || ResourceRefMergeHandler.isResourceRefInjectTargetsConfiguredInInitialWebXML(resourceRefName, mergeContext)) continue;
                ResourceRefType resourceRef = (ResourceRefType)mergeItem.getValue();
                for (InjectionTargetType injectTarget : srcResourceRef.getInjectionTargetArray()) {
                    String resourceRefInjectTargetKey = ResourceRefMergeHandler.createResourceRefInjectTargetKey(resourceRefName, injectTarget.getInjectionTargetClass().getStringValue(), injectTarget.getInjectionTargetName().getStringValue());
                    if (mergeContext.containsAttribute(resourceRefInjectTargetKey)) continue;
                    resourceRef.addNewInjectionTarget().set((XmlObject)injectTarget);
                    mergeContext.setAttribute(resourceRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            ResourceRefType targetResourceRef = (ResourceRefType)webApp.addNewResourceRef().set((XmlObject)srcResourceRef);
            mergeContext.setAttribute(resourceRefKey, new MergeItem(targetResourceRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTargetType injectionTarget : targetResourceRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetKey(resourceRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ResourceRefType resourceRef : webApp.getResourceRefArray()) {
            String resourceRefName = resourceRef.getResRefName().getStringValue();
            mergeContext.setAttribute(ResourceRefMergeHandler.createResourceRefKey(resourceRefName), new MergeItem(resourceRef, null, ElementSource.WEB_XML));
            if (resourceRef.getInjectionTargetArray().length > 0) {
                mergeContext.setAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetConfiguredInWebXMLKey(resourceRefName), Boolean.TRUE);
            }
            for (InjectionTargetType injectionTarget : resourceRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetKey(resourceRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createResourceRefInjectTargetConfiguredInWebXMLKey(String resourceRefName) {
        return RESOURCE_REF_NAME_PREFIX + resourceRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createResourceRefInjectTargetKey(String resourceRefName, String injectTargetClassName, String injectTargetName) {
        return RESOURCE_REF_NAME_PREFIX + resourceRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createResourceRefKey(String resourceRefName) {
        return RESOURCE_REF_NAME_PREFIX + resourceRefName;
    }

    public static boolean isResourceRefInjectTargetConfigured(String resourceRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetKey(resourceRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isResourceRefInjectTargetsConfiguredInInitialWebXML(String resourceRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ResourceRefMergeHandler.createResourceRefInjectTargetConfiguredInWebXMLKey(resourceRefName));
    }
}

