/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.MimeMappingType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class MimeMappingMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (MimeMappingType mimeMapping : webFragment.getMimeMappingArray()) {
            String extension = mimeMapping.getExtension().getStringValue();
            if (MimeMappingMergeHandler.isMimeMappingConfiguredInWebXML(extension, mergeContext)) continue;
            String jarUrl = mergeContext.getCurrentJarUrl();
            String qualifedMimeMappingName = MimeMappingMergeHandler.createMimeMappingConfiguredInWebFragmentXMLKey(extension);
            MergeItem existedMimeMapping = (MergeItem)mergeContext.getAttribute(qualifedMimeMappingName);
            if (existedMimeMapping == null) {
                mergeContext.setAttribute(qualifedMimeMappingName, new MergeItem(mimeMapping.getMimeType().getStringValue(), jarUrl, ElementSource.WEB_FRAGMENT));
                webApp.addNewMimeMapping().set((XmlObject)mimeMapping);
                continue;
            }
            if (mimeMapping.getMimeType().getStringValue().equals(existedMimeMapping.getValue())) continue;
            throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("mime-mapping", "extension", extension, "mime-type", (String)existedMimeMapping.getValue(), existedMimeMapping.getBelongedURL(), mimeMapping.getMimeType().getStringValue(), jarUrl));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (MimeMappingType mimeMapping : webApp.getMimeMappingArray()) {
            context.setAttribute(MimeMappingMergeHandler.createMimeMappingConfiguredInWebXMLKey(mimeMapping.getExtension().getStringValue()), Boolean.TRUE);
        }
    }

    public static String createMimeMappingConfiguredInWebFragmentXMLKey(String extension) {
        return "mime-mapping.extension." + extension + ".configured_in_web_fragment_xml";
    }

    public static String createMimeMappingConfiguredInWebXMLKey(String extension) {
        return "mime-mapping.extension." + extension + ".configured_in_web_xml";
    }

    public static boolean isMimeMappingConfiguredInWebFragmentXML(String extension, MergeContext mergeContext) {
        return mergeContext.containsAttribute(MimeMappingMergeHandler.createMimeMappingConfiguredInWebFragmentXMLKey(extension));
    }

    public static boolean isMimeMappingConfiguredInWebXML(String extension, MergeContext mergeContext) {
        return mergeContext.containsAttribute(MimeMappingMergeHandler.createMimeMappingConfiguredInWebXMLKey(extension));
    }
}

