/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.MessageDestinationRefType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class MessageDestinationRefMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String MESSAGE_DESTINATION_REF_NAME_PREFIX = "message-destination-ref.message-destination-ref-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (MessageDestinationRefType srcMessageDestinationRef : webFragment.getMessageDestinationRefArray()) {
            String messageDestinationRefName = srcMessageDestinationRef.getMessageDestinationRefName().getStringValue();
            String messageDestinationRefKey = MessageDestinationRefMergeHandler.createMessageDestinationRefKey(messageDestinationRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(messageDestinationRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("message-destination-ref", messageDestinationRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || MessageDestinationRefMergeHandler.isMessageDestinationRefInjectTargetsConfiguredInInitialWebXML(messageDestinationRefName, mergeContext)) continue;
                MessageDestinationRefType messageDestinationRef = (MessageDestinationRefType)mergeItem.getValue();
                for (InjectionTargetType injectTarget : srcMessageDestinationRef.getInjectionTargetArray()) {
                    String messageDestinationRefInjectTargetKey = MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetKey(messageDestinationRefName, injectTarget.getInjectionTargetClass().getStringValue(), injectTarget.getInjectionTargetName().getStringValue());
                    if (mergeContext.containsAttribute(messageDestinationRefInjectTargetKey)) continue;
                    messageDestinationRef.addNewInjectionTarget().set((XmlObject)injectTarget);
                    mergeContext.setAttribute(messageDestinationRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            MessageDestinationRefType targetMessageDestinationRef = (MessageDestinationRefType)webApp.addNewMessageDestinationRef().set((XmlObject)srcMessageDestinationRef);
            mergeContext.setAttribute(messageDestinationRefKey, new MergeItem(targetMessageDestinationRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTargetType injectionTarget : targetMessageDestinationRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetKey(messageDestinationRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (MessageDestinationRefType messageDestinationRef : webApp.getMessageDestinationRefArray()) {
            String messageDestinationRefName = messageDestinationRef.getMessageDestinationRefName().getStringValue();
            mergeContext.setAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefKey(messageDestinationRefName), new MergeItem(messageDestinationRef, null, ElementSource.WEB_XML));
            if (messageDestinationRef.getInjectionTargetArray().length > 0) {
                mergeContext.setAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetConfiguredInWebXMLKey(messageDestinationRefName), Boolean.TRUE);
            }
            for (InjectionTargetType injectionTarget : messageDestinationRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetKey(messageDestinationRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createMessageDestinationRefInjectTargetConfiguredInWebXMLKey(String messageDestinationRefName) {
        return MESSAGE_DESTINATION_REF_NAME_PREFIX + messageDestinationRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createMessageDestinationRefInjectTargetKey(String messageDestinationRefName, String injectTargetClassName, String injectTargetName) {
        return MESSAGE_DESTINATION_REF_NAME_PREFIX + messageDestinationRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createMessageDestinationRefKey(String messageDestinationRefName) {
        return MESSAGE_DESTINATION_REF_NAME_PREFIX + messageDestinationRefName;
    }

    public static boolean isMessageDestinationRefInjectTargetConfigured(String messageDestinationRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetKey(messageDestinationRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isMessageDestinationRefInjectTargetsConfiguredInInitialWebXML(String messageDestinationRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(MessageDestinationRefMergeHandler.createMessageDestinationRefInjectTargetConfiguredInWebXMLKey(messageDestinationRefName));
    }
}

