/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeHelper;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.JspConfigType;
import org.apache.geronimo.xbeans.javaee6.TaglibType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspConfigMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    private static final Logger logger = LoggerFactory.getLogger(JspConfigMergeHandler.class);

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        if (webFragment.getJspConfigArray().length == 0) {
            return;
        }
        if (webFragment.getJspConfigArray().length > 1) {
            logger.warn(WebDeploymentMessageUtils.createMultipleConfigurationWarningMessage("jsp-config", mergeContext.getCurrentJarUrl()));
        }
        JspConfigType srcJspConfig = webFragment.getJspConfigArray(0);
        JspConfigType targetJspConfig = webApp.getJspConfigArray().length == 0 ? webApp.addNewJspConfig() : webApp.getJspConfigArray(0);
        for (TaglibType taglibType : srcJspConfig.getTaglibArray()) {
            if (!MergeHelper.mergeRequired(JspConfigMergeHandler.createTaglibKey(taglibType), "jsp-config/tag-lib", "taglib-uri", taglibType.getTaglibUri().getStringValue(), "taglib-location", taglibType.getTaglibLocation().getStringValue(), mergeContext)) continue;
            TaglibType newTaglib = targetJspConfig.addNewTaglib();
            newTaglib.set((XmlObject)taglibType);
        }
        for (TaglibType taglibType : srcJspConfig.getJspPropertyGroupArray()) {
            targetJspConfig.addNewJspPropertyGroup().set((XmlObject)taglibType);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        if (webApp.getJspConfigArray().length == 0) {
            return;
        }
        if (webApp.getJspConfigArray().length > 1) {
            throw new DeploymentException(WebDeploymentMessageUtils.createMultipleConfigurationWebAppErrorMessage("jsp-config"));
        }
        JspConfigType jspConfig = webApp.getJspConfigArray(0);
        for (TaglibType taglib : jspConfig.getTaglibArray()) {
            context.setAttribute(JspConfigMergeHandler.createTaglibKey(taglib), new MergeItem(taglib.getTaglibLocation().getStringValue(), null, ElementSource.WEB_XML));
        }
    }

    public static String createTaglibKey(TaglibType taglib) {
        return "jsp-config.taglib.taglib-uri." + taglib.getTaglibUri().getStringValue();
    }
}

