/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.xbeans.javaee6.FilterMappingType;
import org.apache.geronimo.xbeans.javaee6.ServletNameType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.xmlbeans.XmlObject;

public class FilterMappingServletNameMergeHandler
implements SubMergeHandler<FilterMappingType, FilterMappingType> {
    @Override
    public void add(FilterMappingType filterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = filterMapping.getFilterName().getStringValue();
        for (ServletNameType servletName : filterMapping.getServletNameArray()) {
            mergeContext.setAttribute(FilterMappingServletNameMergeHandler.createFilterMappingServletNameKey(filterName, servletName.getStringValue()), Boolean.TRUE);
        }
    }

    @Override
    public void merge(FilterMappingType srcFilterMapping, FilterMappingType targetFilterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = srcFilterMapping.getFilterName().getStringValue();
        for (ServletNameType servletName : srcFilterMapping.getServletNameArray()) {
            String filterMappingServletNameKey = FilterMappingServletNameMergeHandler.createFilterMappingServletNameKey(filterName, servletName.getStringValue());
            if (mergeContext.containsAttribute(filterMappingServletNameKey)) continue;
            targetFilterMapping.addNewServletName().set((XmlObject)servletName);
            mergeContext.setAttribute(filterMappingServletNameKey, Boolean.TRUE);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (FilterMappingType filterMapping : webApp.getFilterMappingArray()) {
            String filterName = filterMapping.getFilterName().getStringValue();
            for (ServletNameType servletName : filterMapping.getServletNameArray()) {
                context.setAttribute(FilterMappingServletNameMergeHandler.createFilterMappingServletNameKey(filterName, servletName.getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createFilterMappingServletNameKey(String filterName, String servletName) {
        return "filter-mapping.filter-name." + filterName + ".servlet-name." + servletName;
    }
}

