/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.xbeans.javaee6.DispatcherType;
import org.apache.geronimo.xbeans.javaee6.FilterMappingType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;

public class FilterMappingDispatcherMergeHandler
implements SubMergeHandler<FilterMappingType, FilterMappingType> {
    @Override
    public void add(FilterMappingType filterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = filterMapping.getFilterName().getStringValue();
        for (DispatcherType dispatcher : filterMapping.getDispatcherArray()) {
            mergeContext.setAttribute(FilterMappingDispatcherMergeHandler.createFilterMappingDispatcherKey(filterName, dispatcher.getStringValue(), mergeContext), Boolean.TRUE);
        }
    }

    @Override
    public void merge(FilterMappingType srcFilterMapping, FilterMappingType targetFilterMapping, MergeContext mergeContext) throws DeploymentException {
        String filterName = srcFilterMapping.getFilterName().getStringValue();
        for (DispatcherType dispatcher : srcFilterMapping.getDispatcherArray()) {
            if (FilterMappingDispatcherMergeHandler.isFilterMappingDispatcherConfigured(filterName, dispatcher.getStringValue(), mergeContext)) continue;
            mergeContext.setAttribute(FilterMappingDispatcherMergeHandler.createFilterMappingDispatcherKey(filterName, dispatcher.getStringValue(), mergeContext), Boolean.TRUE);
            targetFilterMapping.addNewDispatcher().setStringValue(dispatcher.getStringValue());
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (FilterMappingType filterMapping : webApp.getFilterMappingArray()) {
            String filterName = filterMapping.getFilterName().getStringValue();
            for (DispatcherType dispatcher : filterMapping.getDispatcherArray()) {
                context.setAttribute(FilterMappingDispatcherMergeHandler.createFilterMappingDispatcherKey(filterName, dispatcher.getStringValue(), context), Boolean.TRUE);
            }
        }
    }

    public static String createFilterMappingDispatcherKey(String filterName, String dispatcherValue, MergeContext mergeContext) {
        return "filter-mapping.filter-name." + filterName + ".dispatcher." + dispatcherValue;
    }

    public static boolean isFilterMappingDispatcherConfigured(String filterName, String dispatcherValue, MergeContext mergeContext) {
        return mergeContext.containsAttribute(FilterMappingDispatcherMergeHandler.createFilterMappingDispatcherKey(filterName, dispatcherValue, mergeContext));
    }
}

