/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.EjbRefType;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class EjbRefMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String EJB_REF_NAME_PREFIX = "ejb-ref.ejb-ref-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (EjbRefType srcEjbRef : webFragment.getEjbRefArray()) {
            String ejbRefName = srcEjbRef.getEjbRefName().getStringValue();
            String ejbRefKey = EjbRefMergeHandler.createEjbRefKey(ejbRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(ejbRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("ejb-ref", ejbRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || EjbRefMergeHandler.isEjbRefInjectTargetsConfiguredInInitialWebXML(ejbRefName, mergeContext)) continue;
                EjbRefType ejbRef = (EjbRefType)mergeItem.getValue();
                for (InjectionTargetType injectTarget : srcEjbRef.getInjectionTargetArray()) {
                    String ejbRefInjectTargetKey = EjbRefMergeHandler.createEjbRefInjectTargetKey(ejbRefName, injectTarget.getInjectionTargetClass().getStringValue(), injectTarget.getInjectionTargetName().getStringValue());
                    if (mergeContext.containsAttribute(ejbRefInjectTargetKey)) continue;
                    ejbRef.addNewInjectionTarget().set((XmlObject)injectTarget);
                    mergeContext.setAttribute(ejbRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            EjbRefType targetEjbRef = (EjbRefType)webApp.addNewEjbRef().set((XmlObject)srcEjbRef);
            mergeContext.setAttribute(ejbRefKey, new MergeItem(targetEjbRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTargetType injectionTarget : targetEjbRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(EjbRefMergeHandler.createEjbRefInjectTargetKey(ejbRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (EjbRefType ejbRef : webApp.getEjbRefArray()) {
            String ejbRefName = ejbRef.getEjbRefName().getStringValue();
            mergeContext.setAttribute(EjbRefMergeHandler.createEjbRefKey(ejbRefName), new MergeItem(ejbRef, null, ElementSource.WEB_XML));
            if (ejbRef.getInjectionTargetArray().length > 0) {
                mergeContext.setAttribute(EjbRefMergeHandler.createEjbRefInjectTargetConfiguredInWebXMLKey(ejbRefName), Boolean.TRUE);
            }
            for (InjectionTargetType injectionTarget : ejbRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(EjbRefMergeHandler.createEjbRefInjectTargetKey(ejbRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createEjbRefInjectTargetConfiguredInWebXMLKey(String ejbRefName) {
        return EJB_REF_NAME_PREFIX + ejbRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createEjbRefInjectTargetKey(String ejbRefName, String injectTargetClassName, String injectTargetName) {
        return EJB_REF_NAME_PREFIX + ejbRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createEjbRefKey(String ejbRefName) {
        return EJB_REF_NAME_PREFIX + ejbRefName;
    }

    public static boolean isEjbRefInjectTargetConfigured(String ejbRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EjbRefMergeHandler.createEjbRefInjectTargetKey(ejbRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isEjbRefInjectTargetsConfiguredInInitialWebXML(String ejbRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EjbRefMergeHandler.createEjbRefInjectTargetConfiguredInWebXMLKey(ejbRefName));
    }
}

