/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.DataSourceType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class DataSourceMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (DataSourceType srcDataSource : webFragment.getDataSourceArray()) {
            String dataSourceKey = DataSourceMergeHandler.createDataSourceKey(srcDataSource, mergeContext);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(dataSourceKey);
            if (mergeItem != null && mergeItem.isFromWebFragment()) {
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("data-source", srcDataSource.getName().getStringValue(), mergeContext.getCurrentJarUrl(), mergeItem.getBelongedURL()));
            }
            DataSourceType targetDataSource = (DataSourceType)webApp.addNewDataSource().set((XmlObject)srcDataSource);
            mergeContext.setAttribute(dataSourceKey, new MergeItem(targetDataSource, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (DataSourceType dataSource : webApp.getDataSourceArray()) {
            mergeContext.setAttribute(DataSourceMergeHandler.createDataSourceKey(dataSource, mergeContext), new MergeItem(dataSource, null, ElementSource.WEB_XML));
        }
    }

    public static String createDataSourceKey(DataSourceType dataSource, MergeContext mergeContext) {
        return "data-source.name." + dataSource.getName().getStringValue();
    }
}

