/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.annotation;

import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.annotation.AnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletInitParamMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMergeHandler;
import org.apache.geronimo.xbeans.javaee6.IconType;
import org.apache.geronimo.xbeans.javaee6.ParamValueType;
import org.apache.geronimo.xbeans.javaee6.ServletMappingType;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;

public class WebServletAnnotationMergeHandler
implements AnnotationMergeHandler {
    @Override
    public void merge(Class<?>[] classes, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (Class<?> cls : classes) {
            String[] urlPatterns;
            boolean urlPatternsAttributeConfigured;
            if (!HttpServlet.class.isAssignableFrom(cls)) {
                throw new DeploymentException("The class " + cls.getName() + " with WebServlet annotation must extend javax.servlet.HttpServlet");
            }
            WebServlet webServlet = cls.getAnnotation(WebServlet.class);
            boolean valueAttributeConfigured = webServlet.value().length > 0;
            boolean bl = urlPatternsAttributeConfigured = webServlet.urlPatterns().length > 0;
            if (valueAttributeConfigured && urlPatternsAttributeConfigured) {
                throw new DeploymentException("value and urlPatterns must not be configured on the same WebServlet annotation in the class " + cls.getName());
            }
            if (!valueAttributeConfigured && !urlPatternsAttributeConfigured) {
                throw new DeploymentException("At least one of value and urlPatterns attribute should be configured on the WebServlet annotation in the class " + cls.getName());
            }
            String servletName = webServlet.name().length() == 0 ? cls.getName() : webServlet.name();
            String[] stringArray = urlPatterns = valueAttributeConfigured ? webServlet.value() : webServlet.urlPatterns();
            if (ServletMergeHandler.isServletConfigured(servletName, mergeContext)) {
                ServletType targetServlet = ServletMergeHandler.getServlet(servletName, mergeContext);
                for (WebInitParam webInitParam : webServlet.initParams()) {
                    String paramName = webInitParam.name();
                    if (ServletInitParamMergeHandler.isServletInitParamConfigured(servletName, paramName, mergeContext)) continue;
                    ParamValueType newParamValue = targetServlet.addNewInitParam();
                    newParamValue.addNewDescription().setStringValue(webInitParam.description());
                    newParamValue.addNewParamName().setStringValue(webInitParam.name());
                    newParamValue.addNewParamValue().setStringValue(webInitParam.value());
                    ServletInitParamMergeHandler.addServletInitParam(servletName, newParamValue, ElementSource.ANNOTATION, mergeContext.getCurrentJarUrl(), mergeContext);
                }
            } else {
                MultipartConfig multipartConfig;
                ServletType newServlet = webApp.addNewServlet();
                if (!webServlet.displayName().isEmpty()) {
                    newServlet.addNewDisplayName().setStringValue(webServlet.displayName());
                }
                newServlet.addNewServletClass().setStringValue(cls.getName());
                newServlet.addNewServletName().setStringValue(servletName);
                newServlet.addNewAsyncSupported().setBooleanValue(webServlet.asyncSupported());
                if (!webServlet.description().isEmpty()) {
                    newServlet.addNewDescription().setStringValue(webServlet.description());
                }
                if (webServlet.loadOnStartup() != -1) {
                    newServlet.setLoadOnStartup((Object)webServlet.loadOnStartup());
                }
                for (WebInitParam webInitParam : webServlet.initParams()) {
                    ParamValueType paramValue = newServlet.addNewInitParam();
                    paramValue.addNewDescription().setStringValue(webInitParam.description());
                    paramValue.addNewParamName().setStringValue(webInitParam.name());
                    paramValue.addNewParamValue().setStringValue(webInitParam.value());
                }
                if (!webServlet.smallIcon().isEmpty() || !webServlet.largeIcon().isEmpty()) {
                    IconType iconType = newServlet.addNewIcon();
                    if (!webServlet.smallIcon().isEmpty()) {
                        iconType.addNewSmallIcon().setStringValue(webServlet.smallIcon());
                    }
                    if (!webServlet.largeIcon().isEmpty()) {
                        iconType.addNewLargeIcon().setStringValue(webServlet.largeIcon());
                    }
                }
                if ((multipartConfig = cls.getAnnotation(MultipartConfig.class)) != null) {
                    // empty if block
                }
                ServletMergeHandler.addServlet(newServlet, mergeContext);
            }
            if (ServletMappingMergeHandler.isServletMappingConfigured(servletName, mergeContext)) continue;
            ServletMappingType newServletMapping = webApp.addNewServletMapping();
            newServletMapping.addNewServletName().setStringValue(servletName);
            for (String string : urlPatterns) {
                newServletMapping.addNewUrlPattern().setStringValue(string);
            }
            ServletMappingMergeHandler.addServletMapping(newServletMapping, mergeContext);
            mergeContext.setAttribute(ServletMappingMergeHandler.createServletMappingSourceKey(servletName), (Object)ElementSource.ANNOTATION);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
    }
}

