/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.security;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class HTTPMethods {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("[!-~&&[^\\(\\)\\<\\>@,;:\\\\\"/\\[\\]\\?=\\{\\}]]*");
    private final Set<String> methods = new HashSet<String>();
    private boolean isExcluded = false;

    public HTTPMethods() {
    }

    public HTTPMethods(HTTPMethods httpMethods, boolean complemented) {
        this.isExcluded = httpMethods.isExcluded ^ complemented;
        this.methods.addAll(httpMethods.methods);
    }

    public void add(String httpMethod) {
        if (this.isExcluded) {
            this.checkToken(httpMethod);
            this.methods.remove(httpMethod);
        } else if (httpMethod == null || httpMethod.length() == 0) {
            this.isExcluded = true;
            this.methods.clear();
        } else {
            this.checkToken(httpMethod);
            this.methods.add(httpMethod);
        }
    }

    public HTTPMethods add(HTTPMethods httpMethods) {
        if (this.isExcluded) {
            if (httpMethods.isExcluded) {
                this.methods.retainAll(httpMethods.methods);
            } else {
                this.methods.removeAll(httpMethods.methods);
            }
        } else if (httpMethods.isExcluded) {
            this.isExcluded = true;
            HashSet<String> toRemove = new HashSet<String>(this.methods);
            this.methods.clear();
            this.methods.addAll(httpMethods.methods);
            this.methods.removeAll(toRemove);
        } else {
            this.methods.addAll(httpMethods.methods);
        }
        return this;
    }

    public HTTPMethods remove(HTTPMethods httpMethods) {
        if (this.isExcluded) {
            if (httpMethods.isExcluded) {
                this.isExcluded = false;
                HashSet<String> toRemove = new HashSet<String>(this.methods);
                this.methods.clear();
                this.methods.addAll(httpMethods.methods);
                this.methods.removeAll(toRemove);
            } else {
                this.methods.addAll(httpMethods.methods);
            }
        } else if (httpMethods.isExcluded) {
            this.methods.retainAll(httpMethods.methods);
        } else {
            this.methods.removeAll(httpMethods.methods);
        }
        if (!this.isExcluded && this.methods.isEmpty()) {
            return null;
        }
        return this;
    }

    public String getHttpMethods() {
        return this.getHttpMethodsBuffer(this.isExcluded).toString();
    }

    public StringBuilder getHttpMethodsBuffer() {
        return this.getHttpMethodsBuffer(this.isExcluded);
    }

    public String getComplementedHttpMethods() {
        return this.getHttpMethodsBuffer(!this.isExcluded).toString();
    }

    private StringBuilder getHttpMethodsBuffer(boolean excluded) {
        StringBuilder buffer = new StringBuilder();
        if (excluded) {
            buffer.append("!");
        }
        boolean afterFirst = false;
        for (String method : this.methods) {
            if (afterFirst) {
                buffer.append(",");
            } else {
                afterFirst = true;
            }
            buffer.append(method);
        }
        return buffer;
    }

    private void checkToken(String method) {
        if (!TOKEN_PATTERN.matcher(method).matches()) {
            throw new IllegalArgumentException("Invalid HTTPMethodSpec");
        }
    }

    public boolean isNone() {
        return !this.isExcluded && this.methods.isEmpty();
    }
}

