/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xbeans.ModuleDocument;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.security.GerSecurityDocument;
import org.apache.geronimo.xbeans.geronimo.web.GerWebAppDocument;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericToSpecificPlanConverter {
    private static final QName GENERIC_QNAME = GerWebAppDocument.type.getDocumentElementName();
    private static final String GENERIC_NAMESPACE = GENERIC_QNAME.getNamespaceURI();
    private static final String OLD_GENERIC_NAMESPACE = "http://geronimo.apache.org/xml/ns/web";
    private static final QName GENERIC_CONFIG_QNAME = new QName(GENERIC_NAMESPACE, "container-config");
    private static final QName OLD_GENERIC_CONFIG_QNAME = new QName("http://geronimo.apache.org/xml/ns/web", "container-config");
    private static final String SYSTEM_NAMESPACE = ModuleDocument.type.getDocumentElementName().getNamespaceURI();
    private static final QName SECURITY_QNAME = GerSecurityDocument.type.getDocumentElementName();
    private final String configNamespace;
    private final String namespace;
    private final String element;

    public GenericToSpecificPlanConverter(String configNamespace, String namespace, String element) {
        this.configNamespace = configNamespace;
        this.namespace = namespace;
        this.element = element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlObject convertToSpecificPlan(XmlObject plan) throws DeploymentException {
        XmlCursor rawCursor = plan.newCursor();
        try {
            if (SchemaConversionUtils.findNestedElement((XmlCursor)rawCursor, (String)"web-app")) {
                XmlCursor temp = rawCursor.newCursor();
                String namespace = temp.getName().getNamespaceURI();
                temp.dispose();
                if (!(namespace.equals(GENERIC_NAMESPACE) || namespace.equals(this.namespace) || namespace.equals(OLD_GENERIC_NAMESPACE))) {
                    throw new DeploymentException("Cannot handle web plan with namespace " + namespace + " -- expecting " + GENERIC_NAMESPACE + " or " + this.namespace);
                }
                XmlObject webPlan = rawCursor.getObject().copy();
                XmlCursor cursor = webPlan.newCursor();
                XmlCursor end = cursor.newCursor();
                try {
                    cursor.push();
                    if (cursor.toChild(GENERIC_CONFIG_QNAME) || cursor.toChild(OLD_GENERIC_CONFIG_QNAME)) {
                        XmlCursor source = cursor.newCursor();
                        cursor.push();
                        cursor.toEndToken();
                        cursor.toNextToken();
                        try {
                            if (source.toChild(this.configNamespace, this.element)) {
                                source.copyXmlContents(cursor);
                            }
                        }
                        finally {
                            source.dispose();
                        }
                        cursor.pop();
                        cursor.removeXml();
                    }
                    cursor.pop();
                    cursor.push();
                    while (cursor.hasNextToken()) {
                        if (cursor.isStart() && !SchemaConversionUtils.convertSingleElementToGeronimoSubSchemas((XmlCursor)cursor, (XmlCursor)end) && !this.namespace.equals(cursor.getName().getNamespaceURI())) {
                            cursor.setName(new QName(this.namespace, cursor.getName().getLocalPart()));
                        }
                        cursor.toNextToken();
                    }
                    cursor.pop();
                    cursor.push();
                    Map<Object, List<XmlCursor>> map = GenericToSpecificPlanConverter.createElementMap(cursor);
                    cursor.pop();
                    GenericToSpecificPlanConverter.moveToBottom(cursor, map.get("security-realm-name"));
                    GenericToSpecificPlanConverter.moveToBottom(cursor, map.get("security"));
                    GenericToSpecificPlanConverter.moveToBottom(cursor, map.get("gbean"));
                    GenericToSpecificPlanConverter.moveToBottom(cursor, map.get("persistence"));
                    GenericToSpecificPlanConverter.clearElementMap(map);
                    XmlObject xmlObject = webPlan;
                    return xmlObject;
                }
                finally {
                    cursor.dispose();
                    end.dispose();
                }
            }
            throw new DeploymentException("No web-app element");
        }
        finally {
            rawCursor.dispose();
        }
    }

    private static Map<Object, List<XmlCursor>> createElementMap(XmlCursor cursor) {
        HashMap<Object, List<XmlCursor>> map = new HashMap<Object, List<XmlCursor>>();
        cursor.toStartDoc();
        if (cursor.toFirstChild()) {
            do {
                QName name;
                ArrayList<XmlCursor> locations;
                if ((locations = (ArrayList<XmlCursor>)map.get(name = cursor.getName())) == null) {
                    locations = new ArrayList<XmlCursor>();
                    map.put(name, locations);
                    map.put(name.getLocalPart(), locations);
                }
                locations.add(cursor.newCursor());
            } while (cursor.toNextSibling());
        }
        return map;
    }

    private static void clearElementMap(Map<Object, List<XmlCursor>> map) {
        for (Map.Entry<Object, List<XmlCursor>> entry : map.entrySet()) {
            for (XmlCursor cursor : entry.getValue()) {
                cursor.dispose();
            }
        }
        map.clear();
    }

    private static void moveToBottom(XmlCursor cursor, List<XmlCursor> locations) {
        if (locations != null) {
            for (XmlCursor location : locations) {
                cursor.toEndDoc();
                location.moveXml(cursor);
            }
        }
    }
}

