/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.log;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.TransactionBranchInfo;
import org.apache.geronimo.transaction.manager.TransactionBranchInfoImpl;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.LogClosedException;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.LogRecordSizeException;
import org.objectweb.howl.log.ReplayListener;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.howl.log.xa.XALogger;

public class HOWLLog
implements TransactionLog {
    private static final byte COMMIT = 2;
    private static final byte ROLLBACK = 3;
    static final String[] TYPE_NAMES = new String[]{null, "PREPARE", "COMMIT", "ROLLBACK"};
    private static final Log log = LogFactory.getLog((Class)HOWLLog.class);
    private File serverBaseDir;
    private String logFileDir;
    private final XidFactory xidFactory;
    private final XALogger logger;
    private final Configuration configuration = new Configuration();
    private boolean started = false;
    private HashMap recovered;

    public HOWLLog(String bufferClassName, int bufferSize, boolean checksumEnabled, boolean adler32Checksum, int flushSleepTimeMilliseconds, String logFileDir, String logFileExt, String logFileName, int maxBlocksPerFile, int maxBuffers, int maxLogFiles, int minBuffers, int threadsWaitingForceThreshold, XidFactory xidFactory, File serverBaseDir) throws IOException, LogConfigurationException {
        this.serverBaseDir = serverBaseDir;
        this.setBufferClassName(bufferClassName);
        this.setBufferSizeKBytes(bufferSize);
        this.setChecksumEnabled(checksumEnabled);
        this.setAdler32Checksum(adler32Checksum);
        this.setFlushSleepTimeMilliseconds(flushSleepTimeMilliseconds);
        this.logFileDir = logFileDir;
        this.setLogFileExt(logFileExt);
        this.setLogFileName(logFileName);
        this.setMaxBlocksPerFile(maxBlocksPerFile);
        this.setMaxBuffers(maxBuffers);
        this.setMaxLogFiles(maxLogFiles);
        this.setMinBuffers(minBuffers);
        this.setThreadsWaitingForceThreshold(threadsWaitingForceThreshold);
        this.xidFactory = xidFactory;
        this.logger = new XALogger(this.configuration);
    }

    public String getLogFileDir() {
        return this.logFileDir;
    }

    public void setLogFileDir(String logDirName) {
        File logDir = new File(logDirName);
        if (!logDir.isAbsolute()) {
            logDir = new File(this.serverBaseDir, logDirName);
        }
        this.logFileDir = logDirName;
        if (this.started) {
            this.configuration.setLogFileDir(logDir.getAbsolutePath());
        }
    }

    public String getLogFileExt() {
        return this.configuration.getLogFileExt();
    }

    public void setLogFileExt(String logFileExt) {
        this.configuration.setLogFileExt(logFileExt);
    }

    public String getLogFileName() {
        return this.configuration.getLogFileName();
    }

    public void setLogFileName(String logFileName) {
        this.configuration.setLogFileName(logFileName);
    }

    public boolean isChecksumEnabled() {
        return this.configuration.isChecksumEnabled();
    }

    public void setChecksumEnabled(boolean checksumOption) {
        this.configuration.setChecksumEnabled(checksumOption);
    }

    public boolean isAdler32ChecksumEnabled() {
        return this.configuration.isAdler32ChecksumEnabled();
    }

    public void setAdler32Checksum(boolean checksumOption) {
        this.configuration.setAdler32Checksum(checksumOption);
    }

    public int getBufferSizeKBytes() {
        return this.configuration.getBufferSize();
    }

    public void setBufferSizeKBytes(int bufferSize) throws LogConfigurationException {
        this.configuration.setBufferSize(bufferSize);
    }

    public String getBufferClassName() {
        return this.configuration.getBufferClassName();
    }

    public void setBufferClassName(String bufferClassName) {
        this.configuration.setBufferClassName(bufferClassName);
    }

    public int getMaxBuffers() {
        return this.configuration.getMaxBuffers();
    }

    public void setMaxBuffers(int maxBuffers) throws LogConfigurationException {
        this.configuration.setMaxBuffers(maxBuffers);
    }

    public int getMinBuffers() {
        return this.configuration.getMinBuffers();
    }

    public void setMinBuffers(int minBuffers) throws LogConfigurationException {
        this.configuration.setMinBuffers(minBuffers);
    }

    public int getFlushSleepTimeMilliseconds() {
        return this.configuration.getFlushSleepTime();
    }

    public void setFlushSleepTimeMilliseconds(int flushSleepTime) {
        this.configuration.setFlushSleepTime(flushSleepTime);
    }

    public int getThreadsWaitingForceThreshold() {
        return this.configuration.getThreadsWaitingForceThreshold();
    }

    public void setThreadsWaitingForceThreshold(int threadsWaitingForceThreshold) {
        this.configuration.setThreadsWaitingForceThreshold(threadsWaitingForceThreshold == -1 ? Integer.MAX_VALUE : threadsWaitingForceThreshold);
    }

    public int getMaxBlocksPerFile() {
        return this.configuration.getMaxBlocksPerFile();
    }

    public void setMaxBlocksPerFile(int maxBlocksPerFile) {
        this.configuration.setMaxBlocksPerFile(maxBlocksPerFile == -1 ? Integer.MAX_VALUE : maxBlocksPerFile);
    }

    public int getMaxLogFiles() {
        return this.configuration.getMaxLogFiles();
    }

    public void setMaxLogFiles(int maxLogFiles) {
        this.configuration.setMaxLogFiles(maxLogFiles);
    }

    public void doStart() throws Exception {
        this.started = true;
        this.setLogFileDir(this.logFileDir);
        log.debug((Object)"Initiating transaction manager recovery");
        this.recovered = new HashMap();
        this.logger.open(null);
        GeronimoReplayListener replayListener = new GeronimoReplayListener(this.xidFactory, this.recovered);
        this.logger.replayActiveTx((ReplayListener)replayListener);
        log.debug((Object)"In doubt transactions recovered from log");
    }

    public void doStop() throws Exception {
        this.started = false;
        this.logger.close();
        this.recovered = null;
    }

    public void doFail() {
    }

    public void begin(Xid xid) throws LogException {
    }

    public Object prepare(Xid xid, List branches) throws LogException {
        int branchCount = branches.size();
        byte[][] data = new byte[3 + 2 * branchCount][];
        data[0] = this.intToBytes(xid.getFormatId());
        data[1] = xid.getGlobalTransactionId();
        data[2] = xid.getBranchQualifier();
        int i = 3;
        Iterator iterator = branches.iterator();
        while (iterator.hasNext()) {
            TransactionBranchInfo transactionBranchInfo = (TransactionBranchInfo)iterator.next();
            data[i++] = transactionBranchInfo.getBranchXid().getBranchQualifier();
            data[i++] = transactionBranchInfo.getResourceName().getBytes();
        }
        try {
            XACommittingTx committingTx = this.logger.putCommit((byte[][])data);
            return committingTx;
        }
        catch (LogClosedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogRecordSizeException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogFileOverflowException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (InterruptedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (IOException e) {
            throw new LogException(e);
        }
    }

    public void commit(Xid xid, Object logMark) throws LogException {
        byte[][] data = new byte[][]{{2}, this.intToBytes(xid.getFormatId()), xid.getGlobalTransactionId(), xid.getBranchQualifier()};
        try {
            this.logger.putDone((byte[][])data, (XACommittingTx)logMark);
        }
        catch (LogClosedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogRecordSizeException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogFileOverflowException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (InterruptedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (IOException e) {
            throw new LogException(e);
        }
    }

    public void rollback(Xid xid, Object logMark) throws LogException {
        byte[][] data = new byte[][]{{3}, this.intToBytes(xid.getFormatId()), xid.getGlobalTransactionId(), xid.getBranchQualifier()};
        try {
            this.logger.putDone((byte[][])data, (XACommittingTx)logMark);
        }
        catch (LogClosedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogRecordSizeException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogFileOverflowException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (InterruptedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (IOException e) {
            throw new LogException(e);
        }
    }

    public Collection recover(XidFactory xidFactory) throws LogException {
        log.debug((Object)"Initiating transaction manager recovery");
        HashMap recovered = new HashMap();
        GeronimoReplayListener replayListener = new GeronimoReplayListener(xidFactory, recovered);
        this.logger.replayActiveTx((ReplayListener)replayListener);
        log.debug((Object)"In doubt transactions recovered from log");
        return recovered.values();
    }

    public String getXMLStats() {
        return this.logger.getStats();
    }

    public int getAverageForceTime() {
        return 0;
    }

    public int getAverageBytesPerForce() {
        return 0;
    }

    private byte[] intToBytes(int formatId) {
        byte[] buffer = new byte[]{(byte)(formatId >> 24), (byte)(formatId >> 16), (byte)(formatId >> 8), (byte)(formatId >> 0)};
        return buffer;
    }

    private int bytesToInt(byte[] buffer) {
        return buffer[0] << 24 + buffer[1] << 16 + buffer[2] << 8 + buffer[3] << 0;
    }

    private class GeronimoReplayListener
    implements ReplayListener {
        private final XidFactory xidFactory;
        private final Map recoveredTx;
        static final /* synthetic */ boolean $assertionsDisabled;

        public GeronimoReplayListener(XidFactory xidFactory, Map recoveredTx) {
            this.xidFactory = xidFactory;
            this.recoveredTx = recoveredTx;
        }

        public void onRecord(LogRecord plainlr) {
            XALogRecord lr = (XALogRecord)plainlr;
            short recordType = lr.type;
            XACommittingTx tx = lr.getTx();
            if (recordType == 16512) {
                byte[][] data = tx.getRecord();
                if (!$assertionsDisabled && data[0].length != 4) {
                    throw new AssertionError();
                }
                int formatId = HOWLLog.this.bytesToInt(data[1]);
                byte[] globalId = data[1];
                byte[] branchId = data[2];
                Xid masterXid = this.xidFactory.recover(formatId, globalId, branchId);
                Recovery.XidBranchesPair xidBranchesPair = new Recovery.XidBranchesPair(masterXid, tx);
                this.recoveredTx.put(masterXid, xidBranchesPair);
                log.debug((Object)("recovered prepare record for master xid: " + masterXid));
                for (int i = 3; i < data.length; i += 2) {
                    byte[] branchBranchId = data[i];
                    String name = new String(data[i + 1]);
                    Xid branchXid = this.xidFactory.recover(formatId, globalId, branchBranchId);
                    TransactionBranchInfoImpl branchInfo = new TransactionBranchInfoImpl(branchXid, name);
                    xidBranchesPair.addBranch(branchInfo);
                    log.debug((Object)("recovered branch for resource manager, branchId " + name + ", " + branchXid));
                }
            } else if (recordType != 19983) {
                log.warn((Object)("Received unexpected log record: " + lr + " (" + recordType + ")"));
            }
        }

        public void onError(org.objectweb.howl.log.LogException exception) {
            log.error((Object)"Error during recovery: ", (Throwable)exception);
        }

        public LogRecord getLogRecord() {
            return new LogRecord(1280);
        }

        static {
            $assertionsDisabled = !(class$org$apache$geronimo$transaction$log$HOWLLog == null ? (class$org$apache$geronimo$transaction$log$HOWLLog = HOWLLog.class$("org.apache.geronimo.transaction.log.HOWLLog")) : class$org$apache$geronimo$transaction$log$HOWLLog).desiredAssertionStatus();
        }
    }
}

